/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.access;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.data.CachingDataSetHeader;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.InMemoryDataSet;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessDataContext
extends QueryPostprocessDataContext {
    private static final Logger logger = LoggerFactory.getLogger(AccessDataContext.class);
    private final File _file;
    private Database _database;

    public AccessDataContext(String filename) {
        this(new File(filename));
    }

    public AccessDataContext(File file) {
        super(false);
        this._file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Database getDatabase() {
        if (this._database == null) {
            AccessDataContext accessDataContext = this;
            synchronized (accessDataContext) {
                if (this._database == null) {
                    try {
                        this._database = new DatabaseBuilder(this._file).setReadOnly(true).open();
                    }
                    catch (IOException e) {
                        throw new MetaModelException((Exception)e);
                    }
                }
            }
        }
        return this._database;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this._file.getName());
        Database db = this.getDatabase();
        for (Table mdbTable : db) {
            MutableTable table = new MutableTable(mdbTable.getName(), TableType.TABLE, (Schema)schema);
            try {
                int i = 0;
                for (com.healthmarketscience.jackcess.Column mdbColumn : mdbTable.getColumns()) {
                    ColumnType columnType = ColumnTypeImpl.convertColumnType((int)mdbColumn.getSQLType());
                    MutableColumn column = new MutableColumn(mdbColumn.getName(), columnType, (org.apache.metamodel.schema.Table)table, i, null);
                    column.setColumnSize(Integer.valueOf(mdbColumn.getLength()));
                    column.setNativeType(mdbColumn.getType().name());
                    table.addColumn((Column)column);
                    ++i;
                }
                try {
                    Index primaryKeyIndex = mdbTable.getPrimaryKeyIndex();
                    List columnDescriptors = primaryKeyIndex.getColumns();
                    for (Index.Column columnDescriptor : columnDescriptors) {
                        String name = columnDescriptor.getName();
                        MutableColumn column = (MutableColumn)table.getColumnByName(name);
                        if (column == null) continue;
                        column.setPrimaryKey(true);
                    }
                }
                catch (Exception e) {
                    logger.warn("Failed to get PK index info for table: {}", (Object)mdbTable, (Object)e);
                }
                schema.addTable((org.apache.metamodel.schema.Table)table);
            }
            catch (Exception e) {
                throw new MetaModelException(e);
            }
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._file.getName();
    }

    protected Number executeCountQuery(org.apache.metamodel.schema.Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        try {
            Table mdbTable = this.getDatabase().getTable(table.getName());
            return mdbTable.getRowCount();
        }
        catch (Exception e) {
            throw new MetaModelException(e);
        }
    }

    public DataSet materializeMainSchemaTable(org.apache.metamodel.schema.Table table, List<Column> columns, int maxRows) {
        try {
            Table mdbTable = this.getDatabase().getTable(table.getName());
            List selectItems = columns.stream().map(c -> new SelectItem(c)).collect(Collectors.toList());
            CachingDataSetHeader header = new CachingDataSetHeader(selectItems);
            int rowNum = 0;
            LinkedList<DefaultRow> data = new LinkedList<DefaultRow>();
            Iterator it = mdbTable.iterator();
            while (it.hasNext() && (maxRows < 0 || rowNum < maxRows)) {
                ++rowNum;
                Row valueMap = (Row)it.next();
                Object[] values = new Object[columns.size()];
                for (int j = 0; j < columns.size(); ++j) {
                    values[j] = valueMap.get((Object)columns.get(j).getName());
                }
                data.add(new DefaultRow((DataSetHeader)header, values));
            }
            return new InMemoryDataSet((DataSetHeader)header, data);
        }
        catch (Exception e) {
            throw new MetaModelException(e);
        }
    }

    public File getFile() {
        return this._file;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._database.close();
    }
}

