/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.local.LocalTransport;

public class AssertingLocalTransport
extends LocalTransport {
    public static final String ASSERTING_TRANSPORT_NAME = "asserting_local";
    public static final Setting<Version> ASSERTING_TRANSPORT_MIN_VERSION_KEY = new Setting("transport.asserting.version.min", Integer.toString(Version.CURRENT.minimumCompatibilityVersion().id), s -> Version.fromId((int)Integer.parseInt(s)), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Version> ASSERTING_TRANSPORT_MAX_VERSION_KEY = new Setting("transport.asserting.version.max", Integer.toString(Version.CURRENT.id), s -> Version.fromId((int)Integer.parseInt(s)), new Setting.Property[]{Setting.Property.NodeScope});
    private final Random random;
    private final Version minVersion;
    private final Version maxVersion;

    @Inject
    public AssertingLocalTransport(Settings settings, CircuitBreakerService circuitBreakerService, ThreadPool threadPool, NamedWriteableRegistry namedWriteableRegistry) {
        super(settings, threadPool, namedWriteableRegistry, circuitBreakerService);
        long seed = (Long)ESIntegTestCase.INDEX_TEST_SEED_SETTING.get(settings);
        this.random = new Random(seed);
        this.minVersion = (Version)ASSERTING_TRANSPORT_MIN_VERSION_KEY.get(settings);
        this.maxVersion = (Version)ASSERTING_TRANSPORT_MAX_VERSION_KEY.get(settings);
    }

    protected void handleParsedResponse(TransportResponse response, TransportResponseHandler handler) {
        ElasticsearchAssertions.assertVersionSerializable(VersionUtils.randomVersionBetween(this.random, this.minVersion, this.maxVersion), (Streamable)response, this.namedWriteableRegistry);
        super.handleParsedResponse(response, handler);
    }

    public void sendRequest(LocalTransport targetTransport, DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
        ElasticsearchAssertions.assertVersionSerializable(VersionUtils.randomVersionBetween(this.random, this.minVersion, this.maxVersion), (Streamable)request, this.namedWriteableRegistry);
        super.sendRequest(targetTransport, node, requestId, action, request, options);
    }

    public static class TestPlugin
    extends Plugin
    implements NetworkPlugin {
        public List<Setting<?>> getSettings() {
            return Arrays.asList(ASSERTING_TRANSPORT_MIN_VERSION_KEY, ASSERTING_TRANSPORT_MAX_VERSION_KEY);
        }

        public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
            return Collections.singletonMap(AssertingLocalTransport.ASSERTING_TRANSPORT_NAME, () -> new AssertingLocalTransport(settings, circuitBreakerService, threadPool, namedWriteableRegistry));
        }
    }
}

