/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.hamcrest.RegexMatcher;
import org.elasticsearch.test.rest.yaml.section.Assertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class MatchAssertion
extends Assertion {
    private static final Logger logger = Loggers.getLogger(MatchAssertion.class);

    public static MatchAssertion parse(XContentParser parser) throws IOException {
        XContentLocation location = parser.getTokenLocation();
        Tuple<String, Object> stringObjectTuple = ParserUtils.parseTuple(parser);
        return new MatchAssertion(location, (String)stringObjectTuple.v1(), stringObjectTuple.v2());
    }

    public MatchAssertion(XContentLocation location, String field, Object expectedValue) {
        super(location, field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        String expValue;
        if (expectedValue instanceof String && (expValue = ((String)expectedValue).trim()).length() > 2 && expValue.startsWith("/") && expValue.endsWith("/")) {
            Assert.assertThat((String)("field [" + this.getField() + "] was expected to be of type String but is an instanceof [" + this.safeClass(actualValue) + "]"), (Object)actualValue, (Matcher)Matchers.instanceOf(String.class));
            String stringValue = (String)actualValue;
            String regex = expValue.substring(1, expValue.length() - 1);
            logger.trace("assert that [{}] matches [{}]", (Object)stringValue, (Object)regex);
            Assert.assertThat((String)("field [" + this.getField() + "] was expected to match the provided regex but didn't"), (Object)stringValue, (Matcher)RegexMatcher.matches(regex, 4));
            return;
        }
        Assert.assertNotNull((String)("field [" + this.getField() + "] is null"), (Object)actualValue);
        logger.trace("assert that [{}] matches [{}] (field [{}])", actualValue, expectedValue, (Object)this.getField());
        if (!actualValue.getClass().equals(this.safeClass(expectedValue)) && actualValue instanceof Number && expectedValue instanceof Number) {
            Assert.assertThat((String)("field [" + this.getField() + "] doesn't match the expected value"), (Object)((Number)actualValue).doubleValue(), (Matcher)Matchers.equalTo((Object)((Number)expectedValue).doubleValue()));
            return;
        }
        if (!expectedValue.equals(actualValue)) {
            FailureMessage message = new FailureMessage(this.getField());
            message.compare(this.getField(), actualValue, expectedValue);
            throw new AssertionError(message.message);
        }
    }

    private static class FailureMessage {
        private final StringBuilder message;
        private int indent = 0;

        private FailureMessage(String field) {
            this.message = new StringBuilder(field + " didn't match the expected value:\n");
        }

        private void compareMaps(Map<String, Object> actual, Map<String, Object> expected) {
            actual = new TreeMap<String, Object>(actual);
            expected = new TreeMap<String, Object>(expected);
            for (Map.Entry<String, Object> expectedEntry : expected.entrySet()) {
                this.compare(expectedEntry.getKey(), actual.remove(expectedEntry.getKey()), expectedEntry.getValue());
            }
            for (Map.Entry<String, Object> unmatchedEntry : actual.entrySet()) {
                this.field(unmatchedEntry.getKey(), "unexpected but found [" + unmatchedEntry.getValue() + "]");
            }
        }

        private void compareLists(List<Object> actual, List<Object> expected) {
            int i;
            for (i = 0; i < actual.size() && i < expected.size(); ++i) {
                this.compare(Integer.toString(i), actual.get(i), expected.get(i));
            }
            if (actual.size() == expected.size()) {
                return;
            }
            this.indent();
            if (actual.size() < expected.size()) {
                this.message.append("expected [").append(expected.size() - i).append("] more entries\n");
                return;
            }
            this.message.append("received [").append(actual.size() - i).append("] more entries than expected\n");
        }

        private void compare(String field, @Nullable Object actual, Object expected) {
            if (expected instanceof Map) {
                if (actual == null) {
                    this.field(field, "expected map but not found");
                    return;
                }
                if (!(actual instanceof Map)) {
                    this.field(field, "expected map but found [" + actual + "]");
                    return;
                }
                Map expectedMap = (Map)expected;
                Map actualMap = (Map)actual;
                if (expectedMap.isEmpty() && actualMap.isEmpty()) {
                    this.field(field, "same [empty map]");
                    return;
                }
                this.field(field, null);
                ++this.indent;
                this.compareMaps(actualMap, expectedMap);
                --this.indent;
                return;
            }
            if (expected instanceof List) {
                if (actual == null) {
                    this.field(field, "expected list but not found");
                    return;
                }
                if (!(actual instanceof List)) {
                    this.field(field, "expected list but found [" + actual + "]");
                    return;
                }
                List expectedList = (List)expected;
                List actualList = (List)actual;
                if (expectedList.isEmpty() && actualList.isEmpty()) {
                    this.field(field, "same [empty list]");
                    return;
                }
                this.field(field, null);
                ++this.indent;
                this.compareLists(actualList, expectedList);
                --this.indent;
                return;
            }
            if (actual == null) {
                this.field(field, "expected [" + expected + "] but not found");
                return;
            }
            if (Objects.equals(expected, actual)) {
                if (expected instanceof String) {
                    String expectedString = (String)expected;
                    if (expectedString.length() > 50) {
                        expectedString = expectedString.substring(0, 50) + "...";
                    }
                    this.field(field, "same [" + expectedString + "]");
                    return;
                }
                this.field(field, "same [" + expected + "]");
                return;
            }
            this.field(field, "expected [" + expected + "] but was [" + actual + "]");
        }

        private void indent() {
            for (int i = 0; i < this.indent; ++i) {
                this.message.append("  ");
            }
        }

        private void field(Object name, String info) {
            this.indent();
            this.message.append(String.format(Locale.ROOT, "%30s: ", name));
            if (info != null) {
                this.message.append(info);
            }
            this.message.append('\n');
        }
    }
}

