/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.yaml.section.Assertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class IsTrueAssertion
extends Assertion {
    private static final Logger logger = Loggers.getLogger(IsTrueAssertion.class);

    public static IsTrueAssertion parse(XContentParser parser) throws IOException {
        return new IsTrueAssertion(parser.getTokenLocation(), ParserUtils.parseField(parser));
    }

    public IsTrueAssertion(XContentLocation location, String field) {
        super(location, field, true);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] has a true value (field [{}])", actualValue, (Object)this.getField());
        String errorMessage = this.errorMessage();
        Assert.assertThat((String)errorMessage, (Object)actualValue, (Matcher)Matchers.notNullValue());
        String actualString = actualValue.toString();
        Assert.assertThat((String)errorMessage, (Object)actualString, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"")));
        Assert.assertThat((String)errorMessage, (Object)actualString, (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)Boolean.FALSE.toString())));
        Assert.assertThat((String)errorMessage, (Object)actualString, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"0")));
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] doesn't have a true value";
    }
}

