/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.Version;
import org.elasticsearch.client.Response;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.test.rest.yaml.ObjectPath;
import org.elasticsearch.test.rest.yaml.Stash;

public class ClientYamlTestResponse {
    private final Response response;
    private final Version nodeVersion;
    private final byte[] body;
    private final XContentType bodyContentType;
    private ObjectPath parsedResponse;
    private String bodyAsString;

    public ClientYamlTestResponse(Response response, Version version) throws IOException {
        this.response = response;
        this.nodeVersion = version;
        if (response.getEntity() != null) {
            String contentType = response.getHeader("Content-Type");
            this.bodyContentType = XContentType.fromMediaTypeOrFormat((String)contentType);
            try {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                if (this.bodyContentType != null) {
                    this.parsedResponse = ObjectPath.createFromXContent(this.bodyContentType.xContent(), (BytesReference)new BytesArray(bytes));
                }
                this.body = bytes;
            }
            catch (IOException e) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw e;
            }
        } else {
            this.body = null;
            this.bodyContentType = null;
        }
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getReasonPhrase() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public List<String> getWarningHeaders() {
        ArrayList<String> warningHeaders = new ArrayList<String>();
        for (Header header : this.response.getHeaders()) {
            if (!header.getName().equals("Warning") || this.nodeVersion.onOrAfter(Version.V_5_3_0) && this.response.getRequestLine().getMethod().equals("GET") && this.response.getRequestLine().getUri().contains("source") && !this.response.getRequestLine().getUri().contains("source_content_type") && header.getValue().contains("Deprecated use of the [source] parameter without the [source_content_type] parameter.")) continue;
            warningHeaders.add(header.getValue());
        }
        return warningHeaders;
    }

    public Object getBody() throws IOException {
        if (this.parsedResponse != null) {
            return this.parsedResponse.evaluate("");
        }
        assert (this.bodyContentType == null);
        return this.getBodyAsString();
    }

    public String getBodyAsString() {
        if (this.bodyAsString == null && this.body != null) {
            if (this.bodyContentType == null || this.bodyContentType == XContentType.JSON || this.bodyContentType == XContentType.YAML) {
                this.bodyAsString = new String(this.body, StandardCharsets.UTF_8);
            } else {
                try (XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();){
                    try (XContentParser parser = this.bodyContentType.xContent().createParser(NamedXContentRegistry.EMPTY, this.body);){
                        jsonBuilder.copyCurrentStructure(parser);
                    }
                    this.bodyAsString = jsonBuilder.string();
                }
                catch (IOException e) {
                    throw new UncheckedIOException("unable to convert response body to a string format", e);
                }
            }
        }
        return this.bodyAsString;
    }

    public boolean isError() {
        return this.response.getStatusLine().getStatusCode() >= 400;
    }

    public Object evaluate(String path) throws IOException {
        return this.evaluate(path, Stash.EMPTY);
    }

    public Object evaluate(String path, Stash stash) throws IOException {
        if (this.response == null) {
            return null;
        }
        if (this.parsedResponse == null) {
            if ("".equals(path) && "HEAD".equals(this.response.getRequestLine().getMethod())) {
                return !this.isError();
            }
            return null;
        }
        return this.parsedResponse.evaluate(path, stash);
    }
}

