/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.elasticsearch.Version;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.test.rest.yaml.ClientYamlTestClient;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponseException;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;

public final class ClientYamlDocsTestClient
extends ClientYamlTestClient {
    public ClientYamlDocsTestClient(ClientYamlSuiteRestSpec restSpec, RestClient restClient, List<HttpHost> hosts, Version esVersion, Map<HttpHost, Version> hostVersionMap) throws IOException {
        super(restSpec, restClient, hosts, esVersion, hostVersionMap);
    }

    @Override
    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, HttpEntity entity, Map<String, String> headers) throws IOException {
        if ("raw".equals(apiName)) {
            HashMap<String, String> queryStringParams = new HashMap<String, String>(params);
            String method = (String)Objects.requireNonNull(queryStringParams.remove("method"), "Method must be set to use raw request");
            String path = "/" + (String)Objects.requireNonNull(queryStringParams.remove("path"), "Path must be set to use raw request");
            try {
                Response response = this.restClient.performRequest(method, path, queryStringParams, entity, new Header[0]);
                return new ClientYamlTestResponse(response, (Version)this.hostVersionMap.get(response.getHost()));
            }
            catch (ResponseException e) {
                throw new ClientYamlTestResponseException(e, (Version)this.hostVersionMap.get(e.getResponse().getHost()));
            }
        }
        return super.callApi(apiName, params, entity, headers);
    }
}

