/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.discovery;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.discovery.zen.ZenPing;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.discovery.MockZenPing;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TestZenDiscovery
extends ZenDiscovery {
    public static final Setting<Boolean> USE_MOCK_PINGS = Setting.boolSetting((String)"discovery.zen.use_mock_pings", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    private TestZenDiscovery(Settings settings, ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, ClusterService clusterService, UnicastHostsProvider hostsProvider) {
        super(settings, threadPool, transportService, namedWriteableRegistry, clusterService, hostsProvider);
    }

    protected ZenPing newZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, UnicastHostsProvider hostsProvider) {
        if (((Boolean)USE_MOCK_PINGS.get(settings)).booleanValue()) {
            return new MockZenPing(settings);
        }
        return super.newZenPing(settings, threadPool, transportService, hostsProvider);
    }

    public ZenPing getZenPing() {
        return this.zenPing;
    }

    public static class TestPlugin
    extends Plugin
    implements DiscoveryPlugin {
        private Settings settings;

        public TestPlugin(Settings settings) {
            this.settings = settings;
        }

        public Map<String, Supplier<Discovery>> getDiscoveryTypes(ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, ClusterService clusterService, UnicastHostsProvider hostsProvider) {
            return Collections.singletonMap("test-zen", () -> new TestZenDiscovery(this.settings, threadPool, transportService, namedWriteableRegistry, clusterService, hostsProvider));
        }

        public List<Setting<?>> getSettings() {
            return Collections.singletonList(USE_MOCK_PINGS);
        }

        public Settings additionalSettings() {
            return Settings.builder().put(DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey(), "test-zen").build();
        }
    }
}

