/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.TestUtil;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.action.admin.indices.upgrade.get.IndexUpgradeStatus;
import org.elasticsearch.action.admin.indices.upgrade.get.UpgradeStatusResponse;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.IndexFolderUpgrader;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class OldIndexUtils {
    public static List<String> loadDataFilesList(String prefix, Path bwcIndicesPath) throws IOException {
        ArrayList<String> indexes = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(bwcIndicesPath, prefix + "-*.zip");){
            for (Path path : stream) {
                indexes.add(path.getFileName().toString());
            }
        }
        Collections.sort(indexes);
        return indexes;
    }

    public static Settings getSettings() {
        return Settings.builder().put("index.merge.enabled", false).put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), 30).put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING.getKey(), 30).build();
    }

    public static void upgradeIndexFolder(InternalTestCluster cluster, String nodeName) throws Exception {
        NodeEnvironment nodeEnvironment = cluster.getInstance(NodeEnvironment.class, nodeName);
        IndexFolderUpgrader.upgradeIndicesIfNeeded((Settings)Settings.EMPTY, (NodeEnvironment)nodeEnvironment);
    }

    public static void loadIndex(String indexName, String indexFile, Path unzipDir, Path bwcPath, Logger logger, Path ... paths) throws Exception {
        Path unzipDataDir = unzipDir.resolve("data");
        Path backwardsIndex = bwcPath.resolve(indexFile);
        try (InputStream stream = Files.newInputStream(backwardsIndex, new OpenOption[0]);){
            TestUtil.unzip((InputStream)stream, (Path)unzipDir);
        }
        TestCase.assertTrue((boolean)Files.exists(unzipDataDir, new LinkOption[0]));
        Path[] list = FileSystemUtils.files((Path)unzipDataDir);
        if (list.length != 1) {
            throw new IllegalStateException("Backwards index must contain exactly one cluster");
        }
        Path src = OldIndexUtils.getIndexDir(logger, indexName, indexFile, list[0]);
        OldIndexUtils.copyIndex(logger, src, src.getFileName().toString(), paths);
    }

    public static Path getIndexDir(Logger logger, String indexName, String indexFile, Path dataDir) throws IOException {
        Version version = Version.fromString((String)indexName.substring("index-".length()));
        if (version.before(Version.V_5_0_0_alpha1)) {
            Path src = dataDir.resolve("nodes/0/indices/" + indexName);
            TestCase.assertTrue((String)("[" + indexFile + "] missing index dir: " + src.toString()), (boolean)Files.exists(src, new LinkOption[0]));
            return src;
        }
        ArrayList<Path> indexFolders = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dataDir.resolve("0/indices"), p -> !p.getFileName().toString().startsWith("extra"));){
            for (Path path : stream) {
                indexFolders.add(path);
            }
        }
        MatcherAssert.assertThat((String)((Object)indexFolders).toString(), (Object)indexFolders.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        IndexMetaData indexMetaData = (IndexMetaData)IndexMetaData.FORMAT.loadLatestState(logger, NamedXContentRegistry.EMPTY, new Path[]{(Path)indexFolders.get(0)});
        Assert.assertNotNull((Object)indexMetaData);
        MatcherAssert.assertThat((Object)((Path)indexFolders.get(0)).getFileName().toString(), (Matcher)CoreMatchers.equalTo((Object)indexMetaData.getIndexUUID()));
        MatcherAssert.assertThat((Object)indexMetaData.getCreationVersion(), (Matcher)CoreMatchers.equalTo((Object)version));
        return (Path)indexFolders.get(0);
    }

    public static void assertNotUpgraded(Client client, String ... index) throws Exception {
        for (IndexUpgradeStatus status : OldIndexUtils.getUpgradeStatus(client, index)) {
            TestCase.assertTrue((String)("index " + status.getIndex() + " should not be zero sized"), (status.getTotalBytes() != 0L ? 1 : 0) != 0);
            TestCase.assertTrue((String)("index " + status.getIndex() + " should have recovered some segments from transaction log"), (status.getTotalBytes() >= status.getToUpgradeBytes() ? 1 : 0) != 0);
            TestCase.assertTrue((String)("index " + status.getIndex() + " should need upgrading"), (status.getToUpgradeBytes() != 0L ? 1 : 0) != 0);
        }
    }

    public static Collection<IndexUpgradeStatus> getUpgradeStatus(Client client, String ... indices) throws Exception {
        UpgradeStatusResponse upgradeStatusResponse = (UpgradeStatusResponse)client.admin().indices().prepareUpgradeStatus(indices).get();
        ElasticsearchAssertions.assertNoFailures((BroadcastResponse)upgradeStatusResponse);
        return upgradeStatusResponse.getIndices().values();
    }

    public static void copyIndex(final Logger logger, final Path src, final String folderName, final Path ... dests) throws IOException {
        final Path destinationDataPath = dests[ESTestCase.randomInt(dests.length - 1)];
        for (Path dest : dests) {
            Path indexDir = dest.resolve(folderName);
            TestCase.assertFalse((boolean)Files.exists(indexDir, new LinkOption[0]));
            Files.createDirectories(indexDir, new FileAttribute[0]);
        }
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path relativeDir = src.relativize(dir);
                for (Path dest : dests) {
                    Path destDir = dest.resolve(folderName).resolve(relativeDir);
                    Files.createDirectories(destDir, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().equals("write.lock")) {
                    logger.trace("Skipping lock file: {}", (Object)file);
                    return FileVisitResult.CONTINUE;
                }
                Path relativeFile = src.relativize(file);
                Path destFile = destinationDataPath.resolve(folderName).resolve(relativeFile);
                logger.trace("--> Moving {} to {}", (Object)relativeFile, (Object)destFile);
                Files.move(file, destFile, new CopyOption[0]);
                TestCase.assertFalse((boolean)Files.exists(file, new LinkOption[0]));
                TestCase.assertTrue((boolean)Files.exists(destFile, new LinkOption[0]));
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void assertUpgraded(Client client, String ... index) throws Exception {
        for (IndexUpgradeStatus status : OldIndexUtils.getUpgradeStatus(client, index)) {
            TestCase.assertTrue((String)("index " + status.getIndex() + " should not be zero sized"), (status.getTotalBytes() != 0L ? 1 : 0) != 0);
            Assert.assertEquals((String)("index " + status.getIndex() + " should be upgraded"), (long)0L, (long)status.getToUpgradeBytes());
        }
        IndicesSegmentResponse segsRsp = index == null ? (IndicesSegmentResponse)client.admin().indices().prepareSegments(new String[0]).execute().actionGet() : (IndicesSegmentResponse)client.admin().indices().prepareSegments(index).execute().actionGet();
        for (IndexSegments indexSegments : segsRsp.getIndices().values()) {
            for (IndexShardSegments shard : indexSegments) {
                for (ShardSegments segs : shard.getShards()) {
                    for (Segment seg : segs.getSegments()) {
                        Assert.assertEquals((String)("Index " + indexSegments.getIndex() + " has unupgraded segment " + seg.toString()), (long)Version.CURRENT.luceneVersion.major, (long)seg.version.major);
                        Assert.assertEquals((String)("Index " + indexSegments.getIndex() + " has unupgraded segment " + seg.toString()), (long)Version.CURRENT.luceneVersion.minor, (long)seg.version.minor);
                    }
                }
            }
        }
    }

    public static boolean isUpgraded(Client client, String index) throws Exception {
        Logger logger = Loggers.getLogger(OldIndexUtils.class);
        int toUpgrade = 0;
        for (IndexUpgradeStatus status : OldIndexUtils.getUpgradeStatus(client, index)) {
            logger.info("Index: {}, total: {}, toUpgrade: {}", (Object)status.getIndex(), (Object)status.getTotalBytes(), (Object)status.getToUpgradeBytes());
            toUpgrade = (int)((long)toUpgrade + status.getToUpgradeBytes());
        }
        return toUpgrade == 0;
    }

    public static void assertUpgradeWorks(Client client, String indexName, Version version) throws Exception {
        if (!OldIndexUtils.isLatestLuceneVersion(version)) {
            OldIndexUtils.assertNotUpgraded(client, indexName);
        }
        ElasticsearchAssertions.assertNoFailures((BroadcastResponse)client.admin().indices().prepareUpgrade(new String[]{indexName}).get());
        OldIndexUtils.assertUpgraded(client, indexName);
    }

    public static Version extractVersion(String index) {
        return Version.fromString((String)index.substring(index.indexOf(45) + 1, index.lastIndexOf(46)));
    }

    public static boolean isLatestLuceneVersion(Version version) {
        return version.luceneVersion.major == Version.CURRENT.luceneVersion.major && version.luceneVersion.minor == Version.CURRENT.luceneVersion.minor;
    }
}

