/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.script;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.NativeScriptFactory;
import org.elasticsearch.search.aggregations.bucket.script.TestScript;

public class NativeSignificanceScoreScriptWithParams
extends TestScript {
    public static final String NATIVE_SIGNIFICANCE_SCORE_SCRIPT_WITH_PARAMS = "native_significance_score_script_with_params";
    double factor = 0.0;

    private NativeSignificanceScoreScriptWithParams(Map<String, Object> params) {
        this.factor = ((Number)params.get("param")).doubleValue();
    }

    public Object run() {
        this.checkParams();
        Objects.requireNonNull(Double.valueOf(this.factor), "factor");
        return this.factor * (double)(this._subset_freq.longValue() + this._subset_size.longValue() + this._superset_freq.longValue() + this._superset_size.longValue()) / this.factor;
    }

    public static class Factory
    implements NativeScriptFactory {
        public ExecutableScript newScript(@Nullable Map<String, Object> params) {
            return new NativeSignificanceScoreScriptWithParams(params);
        }

        public boolean needsScores() {
            return false;
        }

        public String getName() {
            return NativeSignificanceScoreScriptWithParams.NATIVE_SIGNIFICANCE_SCORE_SCRIPT_WITH_PARAMS;
        }
    }
}

