/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class HeadBodyIsEmptyIntegTestCase
extends ESRestTestCase {
    public void testHeadRoot() throws IOException {
        this.headTestCase("/", Collections.emptyMap(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/", Collections.singletonMap("pretty", ""), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/", Collections.singletonMap("pretty", "true"), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    private void createTestDoc() throws IOException {
        this.createTestDoc("test", "test");
    }

    private void createTestDoc(String indexName, String typeName) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            builder.field("test", "test");
            builder.endObject();
            HeadBodyIsEmptyIntegTestCase.client().performRequest("PUT", "/" + indexName + "/" + typeName + "/1", Collections.emptyMap(), (HttpEntity)new StringEntity(builder.string()), new Header[0]);
        }
    }

    public void testDocumentExists() throws IOException {
        this.createTestDoc();
        this.headTestCase("/test/test/1", Collections.emptyMap(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/test/test/1", Collections.singletonMap("pretty", "true"), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/test/test/2", Collections.emptyMap(), RestStatus.NOT_FOUND.getStatus(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    public void testIndexExists() throws IOException {
        this.createTestDoc();
        this.headTestCase("/test", Collections.emptyMap(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/test", Collections.singletonMap("pretty", "true"), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    public void testTypeExists() throws IOException {
        this.createTestDoc();
        this.headTestCase("/test/_mapping/test", Collections.emptyMap(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/test/_mapping/test", Collections.singletonMap("pretty", "true"), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    public void testTypeDoesNotExist() throws IOException {
        this.createTestDoc();
        this.headTestCase("/test/_mapping/does-not-exist", Collections.emptyMap(), RestStatus.NOT_FOUND.getStatus(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/text/_mapping/test,does-not-exist", Collections.emptyMap(), RestStatus.NOT_FOUND.getStatus(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    public void testAliasExists() throws IOException {
        this.createTestDoc();
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            builder.startArray("actions");
            builder.startObject();
            builder.startObject("add");
            builder.field("index", "test");
            builder.field("alias", "test_alias");
            builder.endObject();
            builder.endObject();
            builder.endArray();
            builder.endObject();
            HeadBodyIsEmptyIntegTestCase.client().performRequest("POST", "_aliases", Collections.emptyMap(), (HttpEntity)new StringEntity(builder.string()), new Header[0]);
            this.headTestCase("/_alias/test_alias", Collections.emptyMap(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            this.headTestCase("/test/_alias/test_alias", Collections.emptyMap(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
    }

    public void testAliasDoesNotExist() throws IOException {
        this.createTestDoc();
        this.headTestCase("/_alias/test_alias", Collections.emptyMap(), RestStatus.NOT_FOUND.getStatus(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/test/_alias/test_alias", Collections.emptyMap(), RestStatus.NOT_FOUND.getStatus(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    public void testTemplateExists() throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            builder.array("template", new String[]{"*"});
            builder.startObject("settings");
            builder.field("number_of_replicas", 0);
            builder.endObject();
            builder.endObject();
            HeadBodyIsEmptyIntegTestCase.client().performRequest("PUT", "/_template/template", Collections.emptyMap(), (HttpEntity)new StringEntity(builder.string()), new Header[0]);
            this.headTestCase("/_template/template", Collections.emptyMap(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
    }

    public void testGetSourceAction() throws IOException {
        this.createTestDoc();
        this.headTestCase("/test/test/1/_source", Collections.emptyMap(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.headTestCase("/test/test/2/_source", Collections.emptyMap(), RestStatus.NOT_FOUND.getStatus(), (Matcher<Integer>)CoreMatchers.equalTo((Object)0));
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            builder.startObject("mappings");
            builder.startObject("test-no-source");
            builder.startObject("_source");
            builder.field("enabled", false);
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            HeadBodyIsEmptyIntegTestCase.client().performRequest("PUT", "/test-no-source", Collections.emptyMap(), (HttpEntity)new StringEntity(builder.string()), new Header[0]);
            this.createTestDoc("test-no-source", "test-no-source");
            this.headTestCase("/test-no-source/test-no-source/1/_source", Collections.emptyMap(), RestStatus.NOT_FOUND.getStatus(), (Matcher<Integer>)CoreMatchers.equalTo((Object)0));
        }
    }

    public void testException() throws IOException {
        this.headTestCase("/index-not-found-exception", Collections.emptyMap(), RestStatus.NOT_FOUND.getStatus(), (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    private void headTestCase(String url, Map<String, String> params, Matcher<Integer> matcher) throws IOException {
        this.headTestCase(url, params, RestStatus.OK.getStatus(), matcher);
    }

    private void headTestCase(String url, Map<String, String> params, int expectedStatusCode, Matcher<Integer> matcher) throws IOException {
        Response response = HeadBodyIsEmptyIntegTestCase.client().performRequest("HEAD", url, params, new Header[0]);
        HeadBodyIsEmptyIntegTestCase.assertEquals((long)expectedStatusCode, (long)response.getStatusLine().getStatusCode());
        HeadBodyIsEmptyIntegTestCase.assertThat((Object)Integer.valueOf(response.getHeader("Content-Length")), matcher);
        HeadBodyIsEmptyIntegTestCase.assertNull((String)("HEAD requests shouldn't have a response body but " + url + " did"), (Object)response.getEntity());
    }
}

