/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ingest.IngestDocument;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class IngestDocumentMatcher {
    public static void assertIngestDocument(Object a, Object b) {
        if (a instanceof Map) {
            Map mapA = (Map)a;
            Map mapB = (Map)b;
            for (Map.Entry entry : mapA.entrySet()) {
                if (!(entry.getValue() instanceof List) && !(entry.getValue() instanceof Map)) continue;
                IngestDocumentMatcher.assertIngestDocument(entry.getValue(), mapB.get(entry.getKey()));
            }
        } else if (a instanceof List) {
            List listA = (List)a;
            List listB = (List)b;
            for (int i = 0; i < listA.size(); ++i) {
                Object value = listA.get(i);
                if (!(value instanceof List) && !(value instanceof Map)) continue;
                IngestDocumentMatcher.assertIngestDocument(value, listB.get(i));
            }
        } else if (a instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])a), (byte[])((byte[])b));
        } else if (a instanceof IngestDocument) {
            IngestDocument docA = (IngestDocument)a;
            IngestDocument docB = (IngestDocument)b;
            IngestDocumentMatcher.assertIngestDocument(docA.getSourceAndMetadata(), docB.getSourceAndMetadata());
            IngestDocumentMatcher.assertIngestDocument(docA.getIngestMetadata(), docB.getIngestMetadata());
        } else {
            String msg = String.format(Locale.ROOT, "Expected %s class to be equal to %s", a.getClass().getName(), b.getClass().getName());
            Assert.assertThat((String)msg, (Object)a, (Matcher)Matchers.equalTo((Object)b));
        }
    }
}

