/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingHelper;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.TestShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.LocalTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.MapperTestUtils;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexSearcherWrapper;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.test.DummyShardLock;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class IndexShardTestCase
extends ESTestCase {
    protected static final PeerRecoveryTargetService.RecoveryListener recoveryListener = new PeerRecoveryTargetService.RecoveryListener(){

        public void onRecoveryDone(RecoveryState state) {
        }

        public void onRecoveryFailure(RecoveryState state, RecoveryFailedException e, boolean sendShardFailure) {
            throw new AssertionError(e);
        }
    };
    protected ThreadPool threadPool;

    public void setUp() throws Exception {
        super.setUp();
        this.threadPool = new TestThreadPool(((Object)((Object)this)).getClass().getName());
    }

    public void tearDown() throws Exception {
        try {
            ThreadPool.terminate((ThreadPool)this.threadPool, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            super.tearDown();
        }
    }

    private Store createStore(IndexSettings indexSettings, final ShardPath shardPath) throws IOException {
        ShardId shardId = shardPath.getShardId();
        DirectoryService directoryService = new DirectoryService(shardId, indexSettings){

            public Directory newDirectory() throws IOException {
                return LuceneTestCase.newFSDirectory((Path)shardPath.resolveIndex());
            }

            public long throttleTimeInNanos() {
                return 0L;
            }
        };
        return new Store(shardId, indexSettings, directoryService, (ShardLock)new DummyShardLock(shardId));
    }

    protected IndexShard newShard(boolean primary) throws IOException {
        ShardRouting shardRouting = TestShardRouting.newShardRouting(new ShardId("index", "_na_", 0), "n1", primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.StoreRecoverySource.EMPTY_STORE_INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        return this.newShard(shardRouting, new IndexingOperationListener[0]);
    }

    protected IndexShard newShard(ShardRouting shardRouting, IndexingOperationListener ... listeners) throws IOException {
        assert (shardRouting.initializing()) : shardRouting;
        Settings settings = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 0).put("index.number_of_shards", 1).build();
        IndexMetaData.Builder metaData = IndexMetaData.builder((String)shardRouting.getIndexName()).settings(settings).primaryTerm(0, 1L);
        return this.newShard(shardRouting, metaData.build(), listeners);
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, IndexingOperationListener ... listeners) throws IOException {
        ShardRouting shardRouting = TestShardRouting.newShardRouting(shardId, IndexShardTestCase.randomAlphaOfLength(5), primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.StoreRecoverySource.EMPTY_STORE_INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        return this.newShard(shardRouting, listeners);
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, String nodeId, IndexMetaData indexMetaData, @Nullable IndexSearcherWrapper searcherWrapper) throws IOException {
        ShardRouting shardRouting = TestShardRouting.newShardRouting(shardId, nodeId, primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.StoreRecoverySource.EMPTY_STORE_INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        return this.newShard(shardRouting, indexMetaData, searcherWrapper, new IndexingOperationListener[0]);
    }

    protected IndexShard newShard(ShardRouting routing, IndexMetaData indexMetaData, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(routing, indexMetaData, (IndexSearcherWrapper)null, listeners);
    }

    protected IndexShard newShard(ShardRouting routing, IndexMetaData indexMetaData, @Nullable IndexSearcherWrapper indexSearcherWrapper, IndexingOperationListener ... listeners) throws IOException {
        ShardId shardId = routing.shardId();
        NodeEnvironment.NodePath nodePath = new NodeEnvironment.NodePath(IndexShardTestCase.createTempDir());
        ShardPath shardPath = new ShardPath(false, nodePath.resolve(shardId), nodePath.resolve(shardId), shardId);
        return this.newShard(routing, shardPath, indexMetaData, indexSearcherWrapper, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IndexShard newShard(ShardRouting routing, ShardPath shardPath, IndexMetaData indexMetaData, @Nullable IndexSearcherWrapper indexSearcherWrapper, IndexingOperationListener ... listeners) throws IOException {
        Settings nodeSettings = Settings.builder().put("node.name", routing.currentNodeId()).build();
        IndexSettings indexSettings = new IndexSettings(indexMetaData, nodeSettings);
        Store store = this.createStore(indexSettings, shardPath);
        boolean success = false;
        try {
            IndexCache indexCache = new IndexCache(indexSettings, (QueryCache)new DisabledQueryCache(indexSettings), null);
            MapperService mapperService = MapperTestUtils.newMapperService(this.xContentRegistry(), IndexShardTestCase.createTempDir(), indexSettings.getSettings());
            mapperService.merge(indexMetaData, MapperService.MergeReason.MAPPING_RECOVERY, true);
            SimilarityService similarityService = new SimilarityService(indexSettings, Collections.emptyMap());
            IndexEventListener indexEventListener = new IndexEventListener(){};
            Engine.Warmer warmer = searcher -> {};
            IndicesFieldDataCache indicesFieldDataCache = new IndicesFieldDataCache(nodeSettings, new IndexFieldDataCache.Listener(){});
            IndexFieldDataService indexFieldDataService = new IndexFieldDataService(indexSettings, indicesFieldDataCache, (CircuitBreakerService)new NoneCircuitBreakerService(), mapperService);
            return new IndexShard(routing, indexSettings, shardPath, store, indexCache, mapperService, similarityService, indexFieldDataService, null, indexEventListener, indexSearcherWrapper, this.threadPool, BigArrays.NON_RECYCLING_INSTANCE, warmer, Collections.emptyList(), Arrays.asList(listeners));
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.close((Closeable[])new Closeable[]{store});
            throw throwable;
        }
    }

    protected IndexShard reinitShard(IndexShard current, IndexingOperationListener ... listeners) throws IOException {
        ShardRouting shardRouting;
        return this.reinitShard(current, ShardRoutingHelper.initWithSameId(shardRouting, (RecoverySource)((shardRouting = current.routingEntry()).primary() ? RecoverySource.StoreRecoverySource.EXISTING_STORE_INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE)), listeners);
    }

    protected IndexShard reinitShard(IndexShard current, ShardRouting routing, IndexingOperationListener ... listeners) throws IOException {
        this.closeShards(current);
        return this.newShard(routing, current.shardPath(), current.indexSettings().getIndexMetaData(), null, listeners);
    }

    protected IndexShard newStartedShard() throws IOException {
        return this.newStartedShard(IndexShardTestCase.randomBoolean());
    }

    protected IndexShard newStartedShard(boolean primary) throws IOException {
        IndexShard shard = this.newShard(primary);
        if (primary) {
            this.recoveryShardFromStore(shard);
        } else {
            this.recoveryEmptyReplica(shard);
        }
        return shard;
    }

    protected void closeShards(IndexShard ... shards) throws IOException {
        this.closeShards(Arrays.asList(shards));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeShards(Iterable<IndexShard> shards) throws IOException {
        for (IndexShard shard : shards) {
            if (shard == null) continue;
            try {
                shard.close("test", false);
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{shard.store()});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{shard.store()});
        }
    }

    protected void recoveryShardFromStore(IndexShard primary) throws IOException {
        primary.markAsRecovering("store", new RecoveryState(primary.routingEntry(), this.getFakeDiscoNode(primary.routingEntry().currentNodeId()), null));
        primary.recoverFromStore();
        primary.updateRoutingEntry(ShardRoutingHelper.moveToStarted(primary.routingEntry()));
    }

    protected void recoveryEmptyReplica(IndexShard replica) throws IOException {
        IndexShard primary = null;
        try {
            primary = this.newStartedShard(true);
            this.recoverReplica(replica, primary);
        }
        catch (Throwable throwable) {
            this.closeShards(primary);
            throw throwable;
        }
        this.closeShards(primary);
    }

    private DiscoveryNode getFakeDiscoNode(String id) {
        return new DiscoveryNode(id, (TransportAddress)new LocalTransportAddress("_fake_" + id), Version.CURRENT);
    }

    protected void recoverReplica(IndexShard replica, IndexShard primary) throws IOException {
        this.recoverReplica(replica, primary, (r, sourceNode) -> new RecoveryTarget(r, sourceNode, recoveryListener, version -> {}), true);
    }

    protected void recoverReplica(IndexShard replica, IndexShard primary, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier, boolean markAsRecovering) throws IOException {
        DiscoveryNode pNode = this.getFakeDiscoNode(primary.routingEntry().currentNodeId());
        DiscoveryNode rNode = this.getFakeDiscoNode(replica.routingEntry().currentNodeId());
        if (markAsRecovering) {
            replica.markAsRecovering("remote", new RecoveryState(replica.routingEntry(), pNode, rNode));
        } else {
            IndexShardTestCase.assertEquals((Object)replica.state(), (Object)IndexShardState.RECOVERING);
        }
        replica.prepareForIndexRecovery();
        RecoveryTarget recoveryTarget = targetSupplier.apply(replica, pNode);
        String targetAllocationId = recoveryTarget.indexShard().routingEntry().allocationId().getId();
        StartRecoveryRequest request = new StartRecoveryRequest(replica.shardId(), targetAllocationId, pNode, rNode, this.getMetadataSnapshotOrEmpty(replica), false, 0L);
        RecoverySourceHandler recovery = new RecoverySourceHandler(primary, (RecoveryTargetHandler)recoveryTarget, request, () -> 0L, e -> () -> {}, (int)ByteSizeUnit.MB.toKB(1L), this.logger);
        recovery.recoverToTarget();
        recoveryTarget.markAsDone();
        replica.updateRoutingEntry(ShardRoutingHelper.moveToStarted(replica.routingEntry()));
    }

    private Store.MetadataSnapshot getMetadataSnapshotOrEmpty(IndexShard replica) throws IOException {
        Store.MetadataSnapshot result;
        try {
            result = replica.snapshotStoreMetadata();
        }
        catch (IndexNotFoundException e) {
            result = Store.MetadataSnapshot.EMPTY;
        }
        catch (IOException e) {
            this.logger.warn("failed read store, treating as empty", (Throwable)e);
            result = Store.MetadataSnapshot.EMPTY;
        }
        return result;
    }

    protected Set<Uid> getShardDocUIDs(IndexShard shard) throws IOException {
        shard.refresh("get_uids");
        try (Engine.Searcher searcher = shard.acquireSearcher("test");){
            HashSet<Uid> ids = new HashSet<Uid>();
            for (LeafReaderContext leafContext : searcher.reader().leaves()) {
                LeafReader reader = leafContext.reader();
                Bits liveDocs = reader.getLiveDocs();
                for (int i = 0; i < reader.maxDoc(); ++i) {
                    if (liveDocs != null && !liveDocs.get(i)) continue;
                    Document uuid = reader.document(i, Collections.singleton("_uid"));
                    ids.add(Uid.createUid((String)uuid.get("_uid")));
                }
            }
            HashSet<Uid> hashSet = ids;
            return hashSet;
        }
    }

    protected void assertDocCount(IndexShard shard, int docDount) throws IOException {
        IndexShardTestCase.assertThat(this.getShardDocUIDs(shard), (Matcher)Matchers.hasSize((int)docDount));
    }

    protected void assertDocs(IndexShard shard, Uid ... uids) throws IOException {
        Set<Uid> shardDocUIDs = this.getShardDocUIDs(shard);
        IndexShardTestCase.assertThat(shardDocUIDs, (Matcher)Matchers.contains((Object[])uids));
        IndexShardTestCase.assertThat(shardDocUIDs, (Matcher)Matchers.hasSize((int)uids.length));
    }

    protected Engine.Index indexDoc(IndexShard shard, String type, String id) throws IOException {
        return this.indexDoc(shard, type, id, "{}");
    }

    protected Engine.Index indexDoc(IndexShard shard, String type, String id, String source) throws IOException {
        return this.indexDoc(shard, type, id, source, XContentType.JSON);
    }

    protected Engine.Index indexDoc(IndexShard shard, String type, String id, String source, XContentType xContentType) throws IOException {
        Engine.Index index = shard.routingEntry().primary() ? shard.prepareIndexOnPrimary(SourceToParse.source((SourceToParse.Origin)SourceToParse.Origin.PRIMARY, (String)shard.shardId().getIndexName(), (String)type, (String)id, (BytesReference)new BytesArray(source), (XContentType)xContentType), -3L, VersionType.INTERNAL, -1L, false) : shard.prepareIndexOnReplica(SourceToParse.source((SourceToParse.Origin)SourceToParse.Origin.PRIMARY, (String)shard.shardId().getIndexName(), (String)type, (String)id, (BytesReference)new BytesArray(source), (XContentType)xContentType), 1L, VersionType.EXTERNAL, -1L, false);
        shard.index(index);
        return index;
    }

    protected Engine.Delete deleteDoc(IndexShard shard, String type, String id) throws IOException {
        Engine.Delete delete = shard.routingEntry().primary() ? shard.prepareDeleteOnPrimary(type, id, -3L, VersionType.INTERNAL) : shard.prepareDeleteOnPrimary(type, id, 1L, VersionType.EXTERNAL);
        shard.delete(delete);
        return delete;
    }

    protected void flushShard(IndexShard shard) {
        this.flushShard(shard, false);
    }

    protected void flushShard(IndexShard shard, boolean force) {
        shard.flush(new FlushRequest(new String[]{shard.shardId().getIndexName()}).force(force));
    }
}

