/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.en.PorterStemFilterFactory;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilterFactory;
import org.apache.lucene.analysis.reverse.ReverseStringFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.index.analysis.ASCIIFoldingTokenFilterFactory;
import org.elasticsearch.index.analysis.ApostropheFilterFactory;
import org.elasticsearch.index.analysis.ArabicNormalizationFilterFactory;
import org.elasticsearch.index.analysis.ArabicStemTokenFilterFactory;
import org.elasticsearch.index.analysis.BrazilianStemTokenFilterFactory;
import org.elasticsearch.index.analysis.CJKBigramFilterFactory;
import org.elasticsearch.index.analysis.CJKWidthFilterFactory;
import org.elasticsearch.index.analysis.ClassicFilterFactory;
import org.elasticsearch.index.analysis.ClassicTokenizerFactory;
import org.elasticsearch.index.analysis.CommonGramsTokenFilterFactory;
import org.elasticsearch.index.analysis.CzechStemTokenFilterFactory;
import org.elasticsearch.index.analysis.DecimalDigitFilterFactory;
import org.elasticsearch.index.analysis.DelimitedPayloadTokenFilterFactory;
import org.elasticsearch.index.analysis.EdgeNGramTokenFilterFactory;
import org.elasticsearch.index.analysis.EdgeNGramTokenizerFactory;
import org.elasticsearch.index.analysis.ElisionTokenFilterFactory;
import org.elasticsearch.index.analysis.FlattenGraphTokenFilterFactory;
import org.elasticsearch.index.analysis.GermanNormalizationFilterFactory;
import org.elasticsearch.index.analysis.GermanStemTokenFilterFactory;
import org.elasticsearch.index.analysis.HindiNormalizationFilterFactory;
import org.elasticsearch.index.analysis.HtmlStripCharFilterFactory;
import org.elasticsearch.index.analysis.HunspellTokenFilterFactory;
import org.elasticsearch.index.analysis.IndicNormalizationFilterFactory;
import org.elasticsearch.index.analysis.KStemTokenFilterFactory;
import org.elasticsearch.index.analysis.KeepTypesFilterFactory;
import org.elasticsearch.index.analysis.KeepWordFilterFactory;
import org.elasticsearch.index.analysis.KeywordMarkerTokenFilterFactory;
import org.elasticsearch.index.analysis.KeywordTokenizerFactory;
import org.elasticsearch.index.analysis.LengthTokenFilterFactory;
import org.elasticsearch.index.analysis.LetterTokenizerFactory;
import org.elasticsearch.index.analysis.LimitTokenCountFilterFactory;
import org.elasticsearch.index.analysis.LowerCaseTokenFilterFactory;
import org.elasticsearch.index.analysis.LowerCaseTokenizerFactory;
import org.elasticsearch.index.analysis.MappingCharFilterFactory;
import org.elasticsearch.index.analysis.MinHashTokenFilterFactory;
import org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.elasticsearch.index.analysis.NGramTokenFilterFactory;
import org.elasticsearch.index.analysis.NGramTokenizerFactory;
import org.elasticsearch.index.analysis.PathHierarchyTokenizerFactory;
import org.elasticsearch.index.analysis.PatternCaptureGroupTokenFilterFactory;
import org.elasticsearch.index.analysis.PatternReplaceCharFilterFactory;
import org.elasticsearch.index.analysis.PatternReplaceTokenFilterFactory;
import org.elasticsearch.index.analysis.PatternTokenizerFactory;
import org.elasticsearch.index.analysis.PersianNormalizationFilterFactory;
import org.elasticsearch.index.analysis.PorterStemTokenFilterFactory;
import org.elasticsearch.index.analysis.ReverseTokenFilterFactory;
import org.elasticsearch.index.analysis.ScandinavianFoldingFilterFactory;
import org.elasticsearch.index.analysis.ScandinavianNormalizationFilterFactory;
import org.elasticsearch.index.analysis.SerbianNormalizationFilterFactory;
import org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.elasticsearch.index.analysis.SnowballTokenFilterFactory;
import org.elasticsearch.index.analysis.SoraniNormalizationFilterFactory;
import org.elasticsearch.index.analysis.StandardTokenFilterFactory;
import org.elasticsearch.index.analysis.StandardTokenizerFactory;
import org.elasticsearch.index.analysis.StemmerOverrideTokenFilterFactory;
import org.elasticsearch.index.analysis.StemmerTokenFilterFactory;
import org.elasticsearch.index.analysis.StopTokenFilterFactory;
import org.elasticsearch.index.analysis.SynonymGraphTokenFilterFactory;
import org.elasticsearch.index.analysis.SynonymTokenFilterFactory;
import org.elasticsearch.index.analysis.ThaiTokenizerFactory;
import org.elasticsearch.index.analysis.TrimTokenFilterFactory;
import org.elasticsearch.index.analysis.TruncateTokenFilterFactory;
import org.elasticsearch.index.analysis.UAX29URLEmailTokenizerFactory;
import org.elasticsearch.index.analysis.UpperCaseTokenFilterFactory;
import org.elasticsearch.index.analysis.WhitespaceTokenizerFactory;
import org.elasticsearch.index.analysis.WordDelimiterTokenFilterFactory;
import org.elasticsearch.index.analysis.compound.DictionaryCompoundWordTokenFilterFactory;
import org.elasticsearch.index.analysis.compound.HyphenationCompoundWordTokenFilterFactory;
import org.elasticsearch.indices.analysis.PreBuiltCharFilters;
import org.elasticsearch.indices.analysis.PreBuiltTokenFilters;
import org.elasticsearch.indices.analysis.PreBuiltTokenizers;
import org.elasticsearch.test.ESTestCase;

public abstract class AnalysisFactoryTestCase
extends ESTestCase {
    private static final Pattern UNDERSCORE_THEN_ANYTHING;
    static final Map<String, Class<?>> KNOWN_TOKENIZERS;
    static final Map<PreBuiltTokenizers, Class<?>> PREBUILT_TOKENIZERS;
    static final Map<String, Class<?>> KNOWN_TOKENFILTERS;
    static final Map<PreBuiltTokenFilters, Class<?>> PREBUILT_TOKENFILTERS;
    static final Map<String, Class<?>> KNOWN_CHARFILTERS;
    static final Map<PreBuiltCharFilters, Class<?>> PREBUILT_CHARFILTERS;

    private static String toCamelCase(String s) {
        Matcher m = UNDERSCORE_THEN_ANYTHING.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toUpperCase());
        }
        m.appendTail(sb);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    protected Map<String, Class<?>> getTokenizers() {
        return KNOWN_TOKENIZERS;
    }

    protected Map<String, Class<?>> getTokenFilters() {
        return KNOWN_TOKENFILTERS;
    }

    protected Map<String, Class<?>> getCharFilters() {
        return KNOWN_CHARFILTERS;
    }

    public void testTokenizers() {
        TreeSet missing = new TreeSet(TokenizerFactory.availableTokenizers());
        missing.removeAll(this.getTokenizers().keySet());
        AnalysisFactoryTestCase.assertTrue((String)("new tokenizers found, please update KNOWN_TOKENIZERS: " + ((Object)missing).toString()), (boolean)missing.isEmpty());
    }

    public void testCharFilters() {
        TreeSet missing = new TreeSet(CharFilterFactory.availableCharFilters());
        missing.removeAll(this.getCharFilters().keySet());
        AnalysisFactoryTestCase.assertTrue((String)("new charfilters found, please update KNOWN_CHARFILTERS: " + ((Object)missing).toString()), (boolean)missing.isEmpty());
    }

    public void testTokenFilters() {
        TreeSet missing = new TreeSet(TokenFilterFactory.availableTokenFilters());
        missing.removeAll(this.getTokenFilters().keySet());
        AnalysisFactoryTestCase.assertTrue((String)("new tokenfilters found, please update KNOWN_TOKENFILTERS: " + ((Object)missing).toString()), (boolean)missing.isEmpty());
    }

    public void testMultiTermAware() {
        HashSet expected = new HashSet();
        for (Map.Entry<String, Class<?>> entry : this.getTokenizers().entrySet()) {
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(TokenizerFactory.lookupClass((String)entry.getKey()))) continue;
            expected.add(entry.getValue());
        }
        for (Map.Entry<String, Class<?>> entry : this.getTokenFilters().entrySet()) {
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(TokenFilterFactory.lookupClass((String)entry.getKey()))) continue;
            expected.add(entry.getValue());
        }
        for (Map.Entry<String, Class<?>> entry : this.getCharFilters().entrySet()) {
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(CharFilterFactory.lookupClass((String)entry.getKey()))) continue;
            expected.add(entry.getValue());
        }
        expected.remove(Void.class);
        expected.remove(Deprecated.class);
        HashSet actual = new HashSet();
        for (Class<?> clazz : this.getTokenizers().values()) {
            if (!MultiTermAwareComponent.class.isAssignableFrom(clazz)) continue;
            actual.add(clazz);
        }
        for (Class<?> clazz : this.getTokenFilters().values()) {
            if (!MultiTermAwareComponent.class.isAssignableFrom(clazz)) continue;
            actual.add(clazz);
        }
        for (Class<?> clazz : this.getCharFilters().values()) {
            if (!MultiTermAwareComponent.class.isAssignableFrom(clazz)) continue;
            actual.add(clazz);
        }
        HashSet classesMissingMultiTermSupport = new HashSet(expected);
        classesMissingMultiTermSupport.removeAll(actual);
        AnalysisFactoryTestCase.assertTrue((String)("Classes are missing multi-term support: " + classesMissingMultiTermSupport), (boolean)classesMissingMultiTermSupport.isEmpty());
        HashSet classesThatShouldNotHaveMultiTermSupport = new HashSet(actual);
        classesThatShouldNotHaveMultiTermSupport.removeAll(expected);
        AnalysisFactoryTestCase.assertTrue((String)("Classes should not have multi-term support: " + classesThatShouldNotHaveMultiTermSupport), (boolean)classesThatShouldNotHaveMultiTermSupport.isEmpty());
    }

    public void testPreBuiltMultiTermAware() {
        Class<?> luceneFactory;
        HashSet<Object> expected = new HashSet<Object>();
        HashSet<Object> actual = new HashSet<Object>();
        for (Map.Entry<PreBuiltTokenizers, Class<?>> entry : PREBUILT_TOKENIZERS.entrySet()) {
            PreBuiltTokenizers tokenizer = entry.getKey();
            luceneFactory = entry.getValue();
            if (luceneFactory == Void.class) continue;
            AnalysisFactoryTestCase.assertTrue((boolean)TokenizerFactory.class.isAssignableFrom(luceneFactory));
            if (tokenizer.getTokenizerFactory(Version.CURRENT) instanceof MultiTermAwareComponent) {
                actual.add(tokenizer);
            }
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(luceneFactory)) continue;
            expected.add(tokenizer);
        }
        for (Map.Entry<PreBuiltTokenizers, Class<?>> entry : PREBUILT_TOKENFILTERS.entrySet()) {
            PreBuiltTokenFilters tokenFilter = (PreBuiltTokenFilters)entry.getKey();
            luceneFactory = entry.getValue();
            if (luceneFactory == Void.class) continue;
            AnalysisFactoryTestCase.assertTrue((boolean)TokenFilterFactory.class.isAssignableFrom(luceneFactory));
            if (tokenFilter.getTokenFilterFactory(Version.CURRENT) instanceof MultiTermAwareComponent) {
                actual.add(tokenFilter);
            }
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(luceneFactory)) continue;
            expected.add(tokenFilter);
        }
        for (Map.Entry<PreBuiltTokenizers, Class<?>> entry : PREBUILT_CHARFILTERS.entrySet()) {
            PreBuiltCharFilters charFilter = (PreBuiltCharFilters)entry.getKey();
            luceneFactory = entry.getValue();
            if (luceneFactory == Void.class) continue;
            AnalysisFactoryTestCase.assertTrue((boolean)CharFilterFactory.class.isAssignableFrom(luceneFactory));
            if (charFilter.getCharFilterFactory(Version.CURRENT) instanceof MultiTermAwareComponent) {
                actual.add(charFilter);
            }
            if (!org.apache.lucene.analysis.util.MultiTermAwareComponent.class.isAssignableFrom(luceneFactory)) continue;
            expected.add(charFilter);
        }
        HashSet classesMissingMultiTermSupport = new HashSet(expected);
        classesMissingMultiTermSupport.removeAll(actual);
        AnalysisFactoryTestCase.assertTrue((String)("Pre-built components are missing multi-term support: " + classesMissingMultiTermSupport), (boolean)classesMissingMultiTermSupport.isEmpty());
        HashSet hashSet = new HashSet(actual);
        hashSet.removeAll(expected);
        AnalysisFactoryTestCase.assertTrue((String)("Pre-built components should not have multi-term support: " + hashSet), (boolean)hashSet.isEmpty());
    }

    static {
        Class luceneFactoryClazz;
        UNDERSCORE_THEN_ANYTHING = Pattern.compile("_(.)");
        KNOWN_TOKENIZERS = new MapBuilder().put((Object)"classic", ClassicTokenizerFactory.class).put((Object)"edgengram", EdgeNGramTokenizerFactory.class).put((Object)"keyword", KeywordTokenizerFactory.class).put((Object)"letter", LetterTokenizerFactory.class).put((Object)"lowercase", LowerCaseTokenizerFactory.class).put((Object)"ngram", NGramTokenizerFactory.class).put((Object)"pathhierarchy", PathHierarchyTokenizerFactory.class).put((Object)"pattern", PatternTokenizerFactory.class).put((Object)"standard", StandardTokenizerFactory.class).put((Object)"thai", ThaiTokenizerFactory.class).put((Object)"uax29urlemail", UAX29URLEmailTokenizerFactory.class).put((Object)"whitespace", WhitespaceTokenizerFactory.class).put((Object)"wikipedia", Void.class).put((Object)"simplepattern", Void.class).put((Object)"simplepatternsplit", Void.class).immutableMap();
        PREBUILT_TOKENIZERS = new EnumMap(PreBuiltTokenizers.class);
        for (PreBuiltTokenizers preBuiltTokenizers : PreBuiltTokenizers.values()) {
            switch (preBuiltTokenizers) {
                case UAX_URL_EMAIL: {
                    luceneFactoryClazz = org.apache.lucene.analysis.standard.UAX29URLEmailTokenizerFactory.class;
                    break;
                }
                case PATH_HIERARCHY: {
                    luceneFactoryClazz = Void.class;
                    break;
                }
                default: {
                    luceneFactoryClazz = TokenizerFactory.lookupClass((String)AnalysisFactoryTestCase.toCamelCase(preBuiltTokenizers.getTokenizerFactory(Version.CURRENT).name()));
                }
            }
            PREBUILT_TOKENIZERS.put(preBuiltTokenizers, luceneFactoryClazz);
        }
        KNOWN_TOKENFILTERS = new MapBuilder().put((Object)"apostrophe", ApostropheFilterFactory.class).put((Object)"arabicnormalization", ArabicNormalizationFilterFactory.class).put((Object)"arabicstem", ArabicStemTokenFilterFactory.class).put((Object)"asciifolding", ASCIIFoldingTokenFilterFactory.class).put((Object)"brazilianstem", BrazilianStemTokenFilterFactory.class).put((Object)"bulgarianstem", StemmerTokenFilterFactory.class).put((Object)"cjkbigram", CJKBigramFilterFactory.class).put((Object)"cjkwidth", CJKWidthFilterFactory.class).put((Object)"classic", ClassicFilterFactory.class).put((Object)"commongrams", CommonGramsTokenFilterFactory.class).put((Object)"commongramsquery", CommonGramsTokenFilterFactory.class).put((Object)"czechstem", CzechStemTokenFilterFactory.class).put((Object)"decimaldigit", DecimalDigitFilterFactory.class).put((Object)"delimitedpayload", DelimitedPayloadTokenFilterFactory.class).put((Object)"dictionarycompoundword", DictionaryCompoundWordTokenFilterFactory.class).put((Object)"edgengram", EdgeNGramTokenFilterFactory.class).put((Object)"elision", ElisionTokenFilterFactory.class).put((Object)"englishminimalstem", StemmerTokenFilterFactory.class).put((Object)"englishpossessive", StemmerTokenFilterFactory.class).put((Object)"finnishlightstem", StemmerTokenFilterFactory.class).put((Object)"frenchlightstem", StemmerTokenFilterFactory.class).put((Object)"frenchminimalstem", StemmerTokenFilterFactory.class).put((Object)"galicianminimalstem", StemmerTokenFilterFactory.class).put((Object)"galicianstem", StemmerTokenFilterFactory.class).put((Object)"germanstem", GermanStemTokenFilterFactory.class).put((Object)"germanlightstem", StemmerTokenFilterFactory.class).put((Object)"germanminimalstem", StemmerTokenFilterFactory.class).put((Object)"germannormalization", GermanNormalizationFilterFactory.class).put((Object)"greeklowercase", LowerCaseTokenFilterFactory.class).put((Object)"greekstem", StemmerTokenFilterFactory.class).put((Object)"hindinormalization", HindiNormalizationFilterFactory.class).put((Object)"hindistem", StemmerTokenFilterFactory.class).put((Object)"hungarianlightstem", StemmerTokenFilterFactory.class).put((Object)"hunspellstem", HunspellTokenFilterFactory.class).put((Object)"hyphenationcompoundword", HyphenationCompoundWordTokenFilterFactory.class).put((Object)"indicnormalization", IndicNormalizationFilterFactory.class).put((Object)"irishlowercase", LowerCaseTokenFilterFactory.class).put((Object)"indonesianstem", StemmerTokenFilterFactory.class).put((Object)"italianlightstem", StemmerTokenFilterFactory.class).put((Object)"keepword", KeepWordFilterFactory.class).put((Object)"keywordmarker", KeywordMarkerTokenFilterFactory.class).put((Object)"kstem", KStemTokenFilterFactory.class).put((Object)"latvianstem", StemmerTokenFilterFactory.class).put((Object)"length", LengthTokenFilterFactory.class).put((Object)"limittokencount", LimitTokenCountFilterFactory.class).put((Object)"lowercase", LowerCaseTokenFilterFactory.class).put((Object)"ngram", NGramTokenFilterFactory.class).put((Object)"norwegianlightstem", StemmerTokenFilterFactory.class).put((Object)"norwegianminimalstem", StemmerTokenFilterFactory.class).put((Object)"patterncapturegroup", PatternCaptureGroupTokenFilterFactory.class).put((Object)"patternreplace", PatternReplaceTokenFilterFactory.class).put((Object)"persiannormalization", PersianNormalizationFilterFactory.class).put((Object)"porterstem", PorterStemTokenFilterFactory.class).put((Object)"portuguesestem", StemmerTokenFilterFactory.class).put((Object)"portugueselightstem", StemmerTokenFilterFactory.class).put((Object)"portugueseminimalstem", StemmerTokenFilterFactory.class).put((Object)"reversestring", ReverseTokenFilterFactory.class).put((Object)"russianlightstem", StemmerTokenFilterFactory.class).put((Object)"scandinavianfolding", ScandinavianFoldingFilterFactory.class).put((Object)"scandinaviannormalization", ScandinavianNormalizationFilterFactory.class).put((Object)"serbiannormalization", SerbianNormalizationFilterFactory.class).put((Object)"shingle", ShingleTokenFilterFactory.class).put((Object)"minhash", MinHashTokenFilterFactory.class).put((Object)"snowballporter", SnowballTokenFilterFactory.class).put((Object)"soraninormalization", SoraniNormalizationFilterFactory.class).put((Object)"soranistem", StemmerTokenFilterFactory.class).put((Object)"spanishlightstem", StemmerTokenFilterFactory.class).put((Object)"standard", StandardTokenFilterFactory.class).put((Object)"stemmeroverride", StemmerOverrideTokenFilterFactory.class).put((Object)"stop", StopTokenFilterFactory.class).put((Object)"swedishlightstem", StemmerTokenFilterFactory.class).put((Object)"synonym", SynonymTokenFilterFactory.class).put((Object)"synonymgraph", SynonymGraphTokenFilterFactory.class).put((Object)"trim", TrimTokenFilterFactory.class).put((Object)"truncate", TruncateTokenFilterFactory.class).put((Object)"turkishlowercase", LowerCaseTokenFilterFactory.class).put((Object)"type", KeepTypesFilterFactory.class).put((Object)"uppercase", UpperCaseTokenFilterFactory.class).put((Object)"worddelimiter", WordDelimiterTokenFilterFactory.class).put((Object)"worddelimitergraph", WordDelimiterGraphFilterFactory.class).put((Object)"flattengraph", FlattenGraphTokenFilterFactory.class).put((Object)"suggeststop", Void.class).put((Object)"capitalization", Void.class).put((Object)"codepointcount", Void.class).put((Object)"hyphenatedwords", Void.class).put((Object)"keywordrepeat", Void.class).put((Object)"limittokenoffset", Void.class).put((Object)"limittokenposition", Void.class).put((Object)"numericpayload", Void.class).put((Object)"removeduplicates", Void.class).put((Object)"tokenoffsetpayload", Void.class).put((Object)"typeaspayload", Void.class).put((Object)"fingerprint", Void.class).put((Object)"daterecognizer", Void.class).immutableMap();
        PREBUILT_TOKENFILTERS = new EnumMap(PreBuiltTokenFilters.class);
        for (PreBuiltTokenizers preBuiltTokenizers : PreBuiltTokenFilters.values()) {
            switch (1.$SwitchMap$org$elasticsearch$indices$analysis$PreBuiltTokenFilters[preBuiltTokenizers.ordinal()]) {
                case 1: {
                    luceneFactoryClazz = ReverseStringFilterFactory.class;
                    break;
                }
                case 2: {
                    luceneFactoryClazz = Void.class;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    luceneFactoryClazz = SnowballPorterFilterFactory.class;
                    break;
                }
                case 7: {
                    luceneFactoryClazz = PorterStemFilterFactory.class;
                    break;
                }
                case 8: {
                    luceneFactoryClazz = org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilterFactory.class;
                    break;
                }
                case 9: {
                    luceneFactoryClazz = org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilterFactory.class;
                    break;
                }
                default: {
                    luceneFactoryClazz = TokenFilterFactory.lookupClass((String)AnalysisFactoryTestCase.toCamelCase(preBuiltTokenizers.getTokenFilterFactory(Version.CURRENT).name()));
                }
            }
            PREBUILT_TOKENFILTERS.put((PreBuiltTokenFilters)preBuiltTokenizers, luceneFactoryClazz);
        }
        KNOWN_CHARFILTERS = new MapBuilder().put((Object)"htmlstrip", HtmlStripCharFilterFactory.class).put((Object)"mapping", MappingCharFilterFactory.class).put((Object)"patternreplace", PatternReplaceCharFilterFactory.class).put((Object)"persian", Void.class).immutableMap();
        PREBUILT_CHARFILTERS = new EnumMap(PreBuiltCharFilters.class);
        for (PreBuiltTokenizers preBuiltTokenizers : PreBuiltCharFilters.values()) {
            switch (1.$SwitchMap$org$elasticsearch$indices$analysis$PreBuiltCharFilters[preBuiltTokenizers.ordinal()]) {
                default: 
            }
            luceneFactoryClazz = CharFilterFactory.lookupClass((String)AnalysisFactoryTestCase.toCamelCase(preBuiltTokenizers.getCharFilterFactory(Version.CURRENT).name()));
            PREBUILT_CHARFILTERS.put((PreBuiltCharFilters)preBuiltTokenizers, luceneFactoryClazz);
        }
    }
}

