/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.paging;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.terracotta.offheapstore.paging.Page;
import org.terracotta.offheapstore.paging.PageSource;

public class PhantomReferenceLimitedPageSource
implements PageSource {
    private final ReferenceQueue<ByteBuffer> allocatedBuffers = new ReferenceQueue();
    private final Map<PhantomReference<ByteBuffer>, Integer> bufferSizes = new ConcurrentHashMap<PhantomReference<ByteBuffer>, Integer>();
    private final AtomicLong max;

    public PhantomReferenceLimitedPageSource(long max) {
        this.max = new AtomicLong(max);
    }

    @Override
    public Page allocate(int size, boolean thief, boolean victim, OffHeapStorageArea owner) {
        ByteBuffer buffer;
        long now;
        do {
            this.processQueue();
            now = this.max.get();
            if (now >= (long)size) continue;
            return null;
        } while (!this.max.compareAndSet(now, now - (long)size));
        try {
            buffer = ByteBuffer.allocateDirect(size);
        }
        catch (OutOfMemoryError e) {
            return null;
        }
        this.bufferSizes.put(new PhantomReference<ByteBuffer>(buffer, this.allocatedBuffers), size);
        return new Page(buffer, owner);
    }

    @Override
    public void free(Page buffer) {
    }

    private void processQueue() {
        Reference<ByteBuffer> ref;
        while ((ref = this.allocatedBuffers.poll()) != null) {
            Integer size = this.bufferSizes.remove(ref);
            this.max.addAndGet(size.longValue());
        }
        return;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PhantomReferenceLimitedBufferSource\n");
        Collection<Integer> buffers = this.bufferSizes.values();
        sb.append("Bytes Available   : ").append(this.max.get()).append('\n');
        sb.append("Buffers Allocated : (count=").append(buffers.size()).append(") ").append(buffers);
        return sb.toString();
    }
}

