/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.util.EnumSet;
import java.util.Set;
import org.ehcache.config.Builder;
import org.ehcache.core.events.CacheEventListenerConfiguration;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.impl.config.event.DefaultCacheEventListenerConfiguration;

public class CacheEventListenerConfigurationBuilder
implements Builder<CacheEventListenerConfiguration> {
    private EventOrdering eventOrdering;
    private EventFiring eventFiringMode;
    private Object[] listenerArguments = new Object[0];
    private final EnumSet<EventType> eventsToFireOn;
    private final Class<? extends CacheEventListener<?, ?>> listenerClass;
    private final CacheEventListener<?, ?> listenerInstance;

    private CacheEventListenerConfigurationBuilder(EnumSet<EventType> eventsToFireOn, Class<? extends CacheEventListener<?, ?>> listenerClass) {
        this.eventsToFireOn = eventsToFireOn;
        this.listenerClass = listenerClass;
        this.listenerInstance = null;
    }

    private CacheEventListenerConfigurationBuilder(EnumSet<EventType> eventsToFireOn, CacheEventListener<?, ?> listenerInstance) {
        this.eventsToFireOn = eventsToFireOn;
        this.listenerClass = null;
        this.listenerInstance = listenerInstance;
    }

    private CacheEventListenerConfigurationBuilder(CacheEventListenerConfigurationBuilder other) {
        this.eventFiringMode = other.eventFiringMode;
        this.eventOrdering = other.eventOrdering;
        this.eventsToFireOn = EnumSet.copyOf(other.eventsToFireOn);
        this.listenerClass = other.listenerClass;
        this.listenerInstance = other.listenerInstance;
        this.listenerArguments = other.listenerArguments;
    }

    public static CacheEventListenerConfigurationBuilder newEventListenerConfiguration(Class<? extends CacheEventListener<?, ?>> listenerClass, EventType eventType, EventType ... eventTypes) {
        return new CacheEventListenerConfigurationBuilder(EnumSet.of(eventType, eventTypes), listenerClass);
    }

    public static CacheEventListenerConfigurationBuilder newEventListenerConfiguration(CacheEventListener<?, ?> listener, EventType eventType, EventType ... eventTypes) {
        return new CacheEventListenerConfigurationBuilder(EnumSet.of(eventType, eventTypes), listener);
    }

    public static CacheEventListenerConfigurationBuilder newEventListenerConfiguration(Class<? extends CacheEventListener<?, ?>> listenerClass, Set<EventType> eventSetToFireOn) throws IllegalArgumentException {
        if (eventSetToFireOn.isEmpty()) {
            throw new IllegalArgumentException("EventType Set cannot be empty");
        }
        return new CacheEventListenerConfigurationBuilder(EnumSet.copyOf(eventSetToFireOn), listenerClass);
    }

    public static CacheEventListenerConfigurationBuilder newEventListenerConfiguration(CacheEventListener<?, ?> listener, Set<EventType> eventSetToFireOn) throws IllegalArgumentException {
        if (eventSetToFireOn.isEmpty()) {
            throw new IllegalArgumentException("EventType Set cannot be empty");
        }
        return new CacheEventListenerConfigurationBuilder(EnumSet.copyOf(eventSetToFireOn), listener);
    }

    public CacheEventListenerConfigurationBuilder constructedWith(Object ... arguments) {
        if (this.listenerClass == null) {
            throw new IllegalArgumentException("Arguments only are meaningful with class-based builder, this one seems to be an instance-based one");
        }
        CacheEventListenerConfigurationBuilder otherBuilder = new CacheEventListenerConfigurationBuilder(this);
        otherBuilder.listenerArguments = arguments;
        return otherBuilder;
    }

    public CacheEventListenerConfigurationBuilder eventOrdering(EventOrdering eventOrdering) {
        CacheEventListenerConfigurationBuilder otherBuilder = new CacheEventListenerConfigurationBuilder(this);
        otherBuilder.eventOrdering = eventOrdering;
        return otherBuilder;
    }

    public CacheEventListenerConfigurationBuilder ordered() {
        return this.eventOrdering(EventOrdering.ORDERED);
    }

    public CacheEventListenerConfigurationBuilder unordered() {
        return this.eventOrdering(EventOrdering.UNORDERED);
    }

    public CacheEventListenerConfigurationBuilder firingMode(EventFiring eventFiringMode) {
        CacheEventListenerConfigurationBuilder otherBuilder = new CacheEventListenerConfigurationBuilder(this);
        otherBuilder.eventFiringMode = eventFiringMode;
        return otherBuilder;
    }

    public CacheEventListenerConfigurationBuilder synchronous() {
        return this.firingMode(EventFiring.SYNCHRONOUS);
    }

    public CacheEventListenerConfigurationBuilder asynchronous() {
        return this.firingMode(EventFiring.ASYNCHRONOUS);
    }

    @Override
    public DefaultCacheEventListenerConfiguration build() {
        DefaultCacheEventListenerConfiguration defaultCacheEventListenerConfiguration = this.listenerClass != null ? new DefaultCacheEventListenerConfiguration(this.eventsToFireOn, this.listenerClass, this.listenerArguments) : new DefaultCacheEventListenerConfiguration(this.eventsToFireOn, this.listenerInstance);
        if (this.eventOrdering != null) {
            defaultCacheEventListenerConfiguration.setEventOrderingMode(this.eventOrdering);
        }
        if (this.eventFiringMode != null) {
            defaultCacheEventListenerConfiguration.setEventFiringMode(this.eventFiringMode);
        }
        return defaultCacheEventListenerConfiguration;
    }
}

