/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractDoublePointBaseSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.DoublePoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

@ASDU(id=3, name="M_DP_NA_1", informationStructure=InformationStructure.SINGLE)
public class DoublePointInformationSingle
extends AbstractDoublePointBaseSingle {
    private DoublePointInformationSingle(ASDUHeader header, List<InformationEntry<DoublePoint>> entries) {
        super(header, entries, false);
    }

    public static DoublePointInformationSingle parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        return new DoublePointInformationSingle(header, DoublePointInformationSingle.parseEntries(options, length, data, false));
    }

    public static DoublePointInformationSingle create(ASDUHeader header, InformationObjectAddress address, Value<DoublePoint> value) {
        return DoublePointInformationSingle.createInternal(header, Collections.singletonList(new InformationEntry<DoublePoint>(address, value)));
    }

    public static DoublePointInformationSingle create(ASDUHeader header, List<InformationEntry<DoublePoint>> values) {
        if (values.size() > 127) {
            throw new IllegalArgumentException(String.format("A maximum of %s values can be transmitted", 127));
        }
        return DoublePointInformationSingle.createInternal(header, new ArrayList<InformationEntry<DoublePoint>>(values));
    }

    private static DoublePointInformationSingle createInternal(ASDUHeader header, List<InformationEntry<DoublePoint>> values) {
        return new DoublePointInformationSingle(header, values);
    }
}

