/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.session;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.session.IViewingSession;
import org.eclipse.birt.report.session.ViewingCache;

public class ViewingSession
implements IViewingSession,
Serializable {
    private static final long serialVersionUID = -5723569084974892854L;
    private static DateFormatter sessionDateFormatter = new DateFormatter("yyyyMMdd_HHmmss_SSS");
    private String httpSessionId;
    private ViewingCache cache;
    private String id;
    private Date lastAccess;
    private boolean expired;
    private int locks;

    ViewingSession(String httpSessionId, ViewingCache cache) {
        Date date = new Date();
        this.httpSessionId = httpSessionId;
        this.id = sessionDateFormatter.format(date);
        this.lastAccess = date;
        this.cache = cache;
        this.locks = 0;
        this.expired = false;
    }

    public String getId() {
        return this.id;
    }

    public synchronized Date getLastAccess() {
        return this.lastAccess;
    }

    public synchronized void refresh() {
        this.lastAccess = new Date();
    }

    public synchronized String getCachedReportDocument(String reportFile, String viewerId) {
        this.checkExpired();
        return this.cache.getReportDocument(reportFile, this.httpSessionId, this.id, viewerId);
    }

    public synchronized String getImageTempFolder() {
        this.checkExpired();
        return this.cache.getImageTempFolder(this.httpSessionId, this.id);
    }

    private void checkExpired() {
        if (this.expired) {
            throw new IllegalStateException(BirtResources.getMessage("birt.viewer.error.viewingsessionexpired"));
        }
    }

    public boolean isExpired() {
        return this.expired;
    }

    public synchronized void invalidate() {
        this.checkExpired();
        if (this.locks > 0) {
            throw new IllegalStateException(BirtResources.getMessage("birt.viewer.error.viewingsessionlocked"));
        }
        this.expired = true;
        this.deleteCache();
    }

    public synchronized void lock() {
        this.checkExpired();
        ++this.locks;
    }

    public synchronized void unlock() {
        this.checkExpired();
        if (this.locks > 0) {
            --this.locks;
        }
    }

    public boolean isLocked() {
        return this.locks > 0;
    }

    private void deleteCache() {
        this.cache.clearSession(this.httpSessionId, this.id);
    }
}

