/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ScalarParameterBean;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.ParameterDataTypeConverter;
import org.eclipse.birt.report.service.actionhandler.AbstractGetCascadeParameterActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.CascadeParameter;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.SelectItemChoice;
import org.eclipse.birt.report.soapengine.api.SelectionList;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateData;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirtGetCascadeParameterActionHandler
extends AbstractGetCascadeParameterActionHandler {
    public BirtGetCascadeParameterActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    @Override
    protected void __execute() throws Exception {
        ViewerAttributeBean attrBean = (ViewerAttributeBean)this.context.getBean();
        assert (attrBean != null);
        Oprand[] params = this.operation.getOprand();
        LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
        InputOptions options = new InputOptions();
        options.setOption("request", this.context.getRequest());
        options.setOption("locale", attrBean.getLocale());
        options.setOption("timeZone", attrBean.getTimeZone());
        IViewerReportDesignHandle designHandle = attrBean.getReportDesignHandle(this.context.getRequest());
        Map cascParamMap = null;
        for (int i = 0; i < params.length; ++i) {
            ParameterDefinition parameter;
            Oprand param = params[i];
            String paramName = param.getName();
            boolean isLocale = false;
            if ("__isnull".equalsIgnoreCase(paramName)) {
                paramMap.put(param.getValue(), null);
                continue;
            }
            if (paramName.startsWith("__islocale__")) {
                paramName = paramName.replaceFirst("__islocale__", "");
                isLocale = true;
            }
            if ((parameter = attrBean.findParameterDefinition(paramName)) == null) continue;
            String format = parameter.getPattern();
            String dataType = ParameterDataTypeConverter.convertDataType(parameter.getDataType());
            Object paramValue = DataUtil.validate(paramName, dataType, format, param.getValue(), attrBean.getLocale(), attrBean.getTimeZone(), isLocale);
            paramMap.put(paramName, paramValue);
        }
        cascParamMap = this.getParameterSelectionLists(designHandle, paramMap, options, attrBean);
        CascadeParameter cascadeParameter = new CascadeParameter();
        if (cascParamMap != null && cascParamMap.size() > 0) {
            SelectionList[] selectionLists = new SelectionList[cascParamMap.size()];
            int i = 0;
            for (Map.Entry entry : cascParamMap.entrySet()) {
                selectionLists[i] = new SelectionList();
                String name = (String)entry.getKey();
                selectionLists[i].setName(name);
                List selections = (List)entry.getValue();
                SelectItemChoice[] SelectItemChoices = this.getVectorFromList(selections);
                selectionLists[i].setSelections(SelectItemChoices);
                ++i;
            }
            cascadeParameter.setSelectionList(selectionLists);
        }
        this.handleUpdate(cascadeParameter);
    }

    private SelectItemChoice[] getVectorFromList(List list) {
        SelectItemChoice[] selectionList = new SelectItemChoice[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SelectItemChoice item = (SelectItemChoice)list.get(i);
            selectionList[i] = new SelectItemChoice(item.getValue(), item.getLabel());
        }
        return selectionList;
    }

    private Map getParameterSelectionLists(IViewerReportDesignHandle design, Map params, InputOptions options, ViewerAttributeBean attrBean) throws ReportServiceException {
        if (params == null || params.size() == 0) {
            return new HashMap();
        }
        HashMap ret = new HashMap();
        ArrayList<String> remainingParamNames = new ArrayList<String>();
        String firstName = (String)params.keySet().iterator().next();
        Collection paramDefs = attrBean.getParameterDefList();
        ParameterDefinition paramDef = null;
        for (ParameterDefinition temp : paramDefs) {
            if (!temp.getName().equals(firstName)) continue;
            paramDef = temp;
            break;
        }
        if (paramDef == null) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.INVALID_PARAMETER", new String[]{firstName}));
        }
        ParameterGroupDefinition group = paramDef.getGroup();
        if (group != null && group.getParameterCount() > params.size()) {
            int remainingParams = group.getParameterCount() - params.size();
            for (int i = 0; i < remainingParams; ++i) {
                ParameterDefinition def = (ParameterDefinition)group.getParameters().get(params.size() + i);
                remainingParamNames.add(def.getName());
            }
        }
        try {
            if (remainingParamNames.size() > 0) {
                Object[] keyValue = new Object[params.size()];
                Set values = params.keySet();
                Object lastKey2 = null;
                int i = 0;
                for (Object lastKey2 : values) {
                    keyValue[i] = params.get(lastKey2);
                    ++i;
                }
                Object lastParamValue = params.get(lastKey2);
                Object lastParamDefValue = attrBean.getDefaultValues().get(lastKey2);
                boolean keepDefValue = false;
                if (lastParamDefValue != null && lastParamDefValue.equals(lastParamValue)) {
                    keepDefValue = true;
                }
                List<SelectItemChoice> paramList = this.doQueryCascadeParameterSelectionList(remainingParamNames.get(0).toString(), design, group.getName(), keyValue, options, attrBean, keepDefValue);
                ret.put(remainingParamNames.get(0), paramList);
                for (int j = 1; j < remainingParamNames.size(); ++j) {
                    ret.put(remainingParamNames.get(j), new ArrayList());
                }
            }
        }
        catch (RemoteException e) {
            throw new ReportServiceException(e.getLocalizedMessage());
        }
        return ret;
    }

    private List<SelectItemChoice> doQueryCascadeParameterSelectionList(String paramName, IViewerReportDesignHandle design, String groupName, Object[] groupKeys, InputOptions options, ViewerAttributeBean attrBean, boolean keepDefValue) throws RemoteException, ReportServiceException {
        ParameterDefinition parameter = attrBean.findParameterDefinition(paramName);
        Collection list = this.getReportService().getSelectionListForCascadingGroup(design, groupName, groupKeys, options);
        ScalarParameterBean parameterBean = new ScalarParameterBean(parameter);
        parameterBean.setRequired(parameter.isRequired());
        List<ParameterSelectionChoice> selectionList = ParameterUtility.makeSelectionList(list, parameterBean, attrBean.getLocale(), attrBean.getTimeZone(), false);
        return ParameterUtility.toSelectItemChoice(selectionList);
    }

    @Override
    protected void handleUpdate(CascadeParameter cascadeParameter) {
        Data data = new Data();
        data.setCascadeParameter(cascadeParameter);
        UpdateData updateData = new UpdateData();
        updateData.setTarget("birtParameterDialog");
        updateData.setData(data);
        Update update = new Update();
        update.setUpdateData(updateData);
        this.response.setUpdate(new Update[]{update});
    }

    @Override
    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }
}

