/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.metadata.ExtensionException;
import org.eclipse.birt.report.model.metadata.ExtensionLoader;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;

public class EncryptionHelperExtensionLoader
extends ExtensionLoader {
    public static final String EXTENSION_POINT = "org.eclipse.birt.report.model.encryptionHelper";
    private static final String ENCRYPTION_HELPER_TAG = "encryptionHelper";

    public EncryptionHelperExtensionLoader() {
        super(EXTENSION_POINT);
    }

    protected void loadExtension(IExtension extension) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        EncryptionHelperElementLoader loader = new EncryptionHelperElementLoader();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement currentTag = configElements[i];
            if (ENCRYPTION_HELPER_TAG.equals(currentTag.getName())) {
                loader.loadElement(currentTag);
            }
            ++i;
        }
    }

    class EncryptionHelperElementLoader
    extends ExtensionLoader.ExtensionElementLoader {
        private static final String IS_DEFAULT_ATTRIB = "isDefault";

        EncryptionHelperElementLoader() {
            super(EncryptionHelperExtensionLoader.this);
        }

        public void loadElement(IConfigurationElement elementTag) {
            String extensionName = elementTag.getAttribute("extensionName");
            String className = elementTag.getAttribute("class");
            if (!this.checkRequiredAttribute("extensionName", extensionName) || !this.checkRequiredAttribute("class", className)) {
                return;
            }
            boolean isDefault = this.getBooleanAttrib(elementTag, IS_DEFAULT_ATTRIB, false);
            try {
                IEncryptionHelper helper = (IEncryptionHelper)elementTag.createExecutableExtension("class");
                MetaDataDictionary dd = MetaDataDictionary.getInstance();
                dd.addEncryptionHelper(extensionName, helper);
                if (isDefault) {
                    String defaultEncryption = dd.getDefaultEncryptionHelperID();
                    if ("base64".equals(defaultEncryption)) {
                        dd.setDefaultEncryptionHelper(extensionName);
                    } else {
                        EncryptionHelperExtensionLoader.this.handleError(new ExtensionException(new String[]{extensionName, defaultEncryption}, "DEFAULT_ENCRYPTION_EXIST"));
                    }
                }
            }
            catch (FrameworkException frameworkException) {
                EncryptionHelperExtensionLoader.this.handleError(new ExtensionException(new String[]{className}, "FAILED_TO_CREATE_INSTANCE"));
                return;
            }
            catch (MetaDataException e) {
                EncryptionHelperExtensionLoader.this.handleError(e);
                return;
            }
        }
    }
}

