/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.SortHintHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.IDataSetModel;
import org.eclipse.birt.report.model.elements.interfaces.ISimpleDataSetModel;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataSetHandle
extends ReportElementHandle
implements IDataSetModel,
ISimpleDataSetModel {
    public DataSetHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public DataSourceHandle getDataSource() {
        return (DataSourceHandle)this.getElementProperty("dataSource");
    }

    public String getDataSourceName() {
        return this.getStringProperty("dataSource");
    }

    public void setDataSource(String name) throws SemanticException {
        this.setStringProperty("dataSource", name);
    }

    public Iterator parametersIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("parameters");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public Iterator paramBindingsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("paramBindings");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public Iterator resultSetIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("resultSet");
        if (propHandle == null) {
            return Collections.emptyList().iterator();
        }
        return propHandle.iterator();
    }

    public Iterator resultSetHintsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("resultSetHints");
        if (propHandle != null) {
            return propHandle.iterator();
        }
        return Collections.emptyList().iterator();
    }

    public Iterator computedColumnsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("computedColumns");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public Iterator columnHintsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("columnHints");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public Iterator<SortHintHandle> sortHintsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("sortHints");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public String getBeforeOpen() {
        return this.getStringProperty("beforeOpen");
    }

    public void setBeforeOpen(String code) throws SemanticException {
        this.setProperty("beforeOpen", code);
    }

    public String getBeforeClose() {
        return this.getStringProperty("beforeClose");
    }

    public void setBeforeClose(String code) throws SemanticException {
        this.setProperty("beforeClose", code);
    }

    public String getAfterOpen() {
        return this.getStringProperty("afterOpen");
    }

    public void setAfterOpen(String code) throws SemanticException {
        this.setProperty("afterOpen", code);
    }

    public String getAfterClose() {
        return this.getStringProperty("afterClose");
    }

    public void setAfterClose(String code) throws SemanticException {
        this.setProperty("afterClose", code);
    }

    public String getOnFetch() {
        return this.getStringProperty("onFetch");
    }

    public void setOnFetch(String code) throws SemanticException {
        this.setProperty("onFetch", code);
    }

    public CachedMetaDataHandle getCachedMetaDataHandle() {
        PropertyHandle propHandle = this.getPropertyHandle("cachedMetaData");
        assert (propHandle != null);
        CachedMetaData value = (CachedMetaData)propHandle.getValue();
        if (value == null) {
            return null;
        }
        return (CachedMetaDataHandle)value.getHandle(propHandle);
    }

    public CachedMetaDataHandle setCachedMetaData(CachedMetaData metadata) throws SemanticException {
        this.setProperty("cachedMetaData", metadata);
        if (metadata == null) {
            return null;
        }
        return (CachedMetaDataHandle)metadata.getHandle(this.getPropertyHandle("cachedMetaData"));
    }

    @Override
    public PropertyHandle getPropertyHandle(String propName) {
        if ("parameters".equals(propName)) {
            return new DataSetParametersPropertyHandle((DesignElementHandle)this, propName);
        }
        return super.getPropertyHandle(propName);
    }

    public void setDataSetRowLimit(int count) throws SemanticException {
        this.setIntProperty("dataSetRowLimit", count);
    }

    public int getDataSetRowLimit() {
        return this.getIntProperty("dataSetRowLimit");
    }

    public void setCachedRowCount(int count) throws SemanticException {
        this.setDataSetRowLimit(count);
    }

    public int getCachedRowCount() {
        return this.getDataSetRowLimit();
    }

    public void setRowFetchLimit(int count) throws SemanticException {
        this.setIntProperty("rowFetchLimit", count);
    }

    public int getRowFetchLimit() {
        return this.getIntProperty("rowFetchLimit");
    }

    public void addFilter(FilterCondition fc) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        propHandle.addItem(fc);
    }

    public void removeFilter(FilterCondition fc) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        propHandle.removeItem(fc);
    }

    public void setNeedsCache(boolean needsCache) throws SemanticException {
        this.setBooleanProperty("needsCache", needsCache);
    }

    public boolean needsCache() {
        return this.getBooleanProperty("needsCache");
    }

    public ExpressionHandle getACLExpression() {
        return this.getExpressionProperty("ACLExpression");
    }

    public ExpressionHandle getRowACLExpression() {
        return this.getExpressionProperty("rowACLExpression");
    }

    public boolean isVisible() {
        return this.getBooleanProperty("isVisible");
    }

    public void setIsVisible(boolean isVisible) throws SemanticException {
        this.setBooleanProperty("isVisible", isVisible);
    }

    public ULocale getLocale() {
        return (ULocale)this.getProperty("locale");
    }

    public void setLocale(ULocale locale) throws SemanticException {
        this.setProperty("locale", locale);
    }

    public String getNullsOrdering() {
        return this.getStringProperty("nullsOrdering");
    }

    public void setNullsOrdering(String nullsOrdering) throws SemanticException {
        this.setStringProperty("nullsOrdering", nullsOrdering);
    }

    static final class DataSetParametersPropertyHandle
    extends PropertyHandle {
        public DataSetParametersPropertyHandle(DesignElementHandle element, ElementPropertyDefn prop) {
            super(element, prop);
        }

        public DataSetParametersPropertyHandle(DesignElementHandle element, String propName) {
            super(element, propName);
        }

        public void removeItem(int posn) throws PropertyValueException {
            DataSetParameterHandle paramHandle = (DataSetParameterHandle)this.getAt(posn);
            DataSetParameter param = (DataSetParameter)paramHandle.getStructure();
            ActivityStack as = this.getModule().getActivityStack();
            as.startTrans(ModelMessages.getMessage("Message.RemoveItem"));
            try {
                super.removeItem(posn);
            }
            catch (PropertyValueException e) {
                as.rollback();
                throw e;
            }
            try {
                this.removeParamBindingsFor(param.getName());
            }
            catch (PropertyValueException propertyValueException) {}
            as.commit();
        }

        public void removeItem(IStructure item) throws PropertyValueException {
            DataSetParameter param = (DataSetParameter)item;
            ActivityStack as = this.getModule().getActivityStack();
            as.startTrans(CommandLabelFactory.getCommandLabel("Message.RemoveItem"));
            try {
                super.removeItem(item);
            }
            catch (PropertyValueException e) {
                as.rollback();
                throw e;
            }
            try {
                this.removeParamBindingsFor(param.getName());
            }
            catch (PropertyValueException propertyValueException) {}
            as.commit();
        }

        public void removeItems(List items) throws PropertyValueException {
            ActivityStack as = this.getModule().getActivityStack();
            as.startTrans(CommandLabelFactory.getCommandLabel("Message.RemoveItem"));
            try {
                super.removeItems(items);
            }
            catch (PropertyValueException e) {
                as.rollback();
                throw e;
            }
            try {
                this.removeParamBindingsFor(items);
            }
            catch (PropertyValueException propertyValueException) {}
            as.commit();
        }

        public void replaceItem(IStructure oldItem, IStructure newItem) throws SemanticException {
            ActivityStack as = this.getModule().getActivityStack();
            as.startTrans(CommandLabelFactory.getCommandLabel("Message.ReplaceItem"));
            try {
                super.replaceItem(oldItem, newItem);
            }
            catch (PropertyValueException e) {
                as.rollback();
                throw e;
            }
            this.updateParamBindings(((DataSetParameter)oldItem).getName(), ((DataSetParameter)newItem).getName());
            as.commit();
        }

        public void setValue(Object value) throws SemanticException {
            ArrayList paramList = this.getListValue();
            ActivityStack as = this.getModule().getActivityStack();
            as.startTrans(this.changePropertyMessage());
            try {
                super.setValue(value);
            }
            catch (PropertyValueException e) {
                as.rollback();
                throw e;
            }
            try {
                this.removeParamBindingsFor(paramList);
            }
            catch (PropertyValueException propertyValueException) {}
            as.commit();
        }

        public void clearValue() throws SemanticException {
            ArrayList paramList = this.getListValue();
            ActivityStack as = this.getModule().getActivityStack();
            as.startTrans(this.changePropertyMessage());
            try {
                super.clearValue();
            }
            catch (PropertyValueException e) {
                as.rollback();
                throw e;
            }
            try {
                this.removeParamBindingsFor(paramList);
            }
            catch (PropertyValueException propertyValueException) {}
            as.commit();
        }

        private String changePropertyMessage() {
            return CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{this.propDefn.getDisplayName()});
        }

        private void removeParamBindingsFor(List params) throws PropertyValueException {
            if (params == null) {
                return;
            }
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                String paramName = null;
                Object item = iter.next();
                if (item instanceof DataSetParameterHandle) {
                    paramName = ((DataSetParameterHandle)item).getName();
                } else if (item instanceof DataSetParameter) {
                    paramName = ((DataSetParameter)item).getName();
                } else assert (false);
                this.removeParamBindingsFor(paramName);
            }
        }

        private void removeParamBindingsFor(String paramName) throws PropertyValueException {
            if (paramName == null) {
                return;
            }
            Iterator iter = this.getElementHandle().clientsIterator();
            while (iter.hasNext()) {
                DesignElementHandle client = (DesignElementHandle)iter.next();
                PropertyHandle paramBindingsPropHandle = client.getPropertyHandle("paramBindings");
                DataSetParametersPropertyHandle.removeParamBindingFor(paramBindingsPropHandle, paramName);
                PropertyHandle actionPropHandle = client.getPropertyHandle("action");
                if (actionPropHandle == null) continue;
                Iterator actionIter = actionPropHandle.iterator();
                while (actionIter.hasNext()) {
                    ActionHandle actionHandle = (ActionHandle)actionIter.next();
                    MemberHandle paramBindingsMemberHandle = actionHandle.getMember("paramBindings");
                    DataSetParametersPropertyHandle.removeParamBindingFor(paramBindingsMemberHandle, paramName);
                }
            }
            PropertyHandle paramBindingsPropHandle = this.getElementHandle().getPropertyHandle("paramBindings");
            DataSetParametersPropertyHandle.removeParamBindingFor(paramBindingsPropHandle, paramName);
        }

        private static void removeParamBindingFor(SimpleValueHandle paramBindingsPropHandle, String paramName) throws PropertyValueException {
            if (paramBindingsPropHandle == null) {
                return;
            }
            ArrayList<ParamBindingHandle> bindings = new ArrayList<ParamBindingHandle>();
            Iterator bindingIter = paramBindingsPropHandle.iterator();
            while (bindingIter.hasNext()) {
                ParamBindingHandle bindingHandle = (ParamBindingHandle)bindingIter.next();
                if (!paramName.equals(bindingHandle.getParamName())) continue;
                bindings.add(bindingHandle);
            }
            paramBindingsPropHandle.removeItems(bindings);
        }

        void updateParamBindings(String oldParamName, String newParamName) {
            Iterator iter = this.getElementHandle().clientsIterator();
            while (iter.hasNext()) {
                DesignElementHandle client = (DesignElementHandle)iter.next();
                PropertyHandle paramBindingsPropHandle = client.getPropertyHandle("paramBindings");
                DataSetParametersPropertyHandle.updateParamBindings(paramBindingsPropHandle, oldParamName, newParamName);
                PropertyHandle actionPropHandle = client.getPropertyHandle("action");
                if (actionPropHandle == null) continue;
                Iterator actionIter = actionPropHandle.iterator();
                while (actionIter.hasNext()) {
                    ActionHandle actionHandle = (ActionHandle)actionIter.next();
                    MemberHandle paramBindingsMemberHandle = actionHandle.getMember("paramBindings");
                    DataSetParametersPropertyHandle.updateParamBindings(paramBindingsMemberHandle, oldParamName, newParamName);
                }
            }
            PropertyHandle paramBindingsPropHandle = this.getElementHandle().getPropertyHandle("paramBindings");
            DataSetParametersPropertyHandle.updateParamBindings(paramBindingsPropHandle, oldParamName, newParamName);
        }

        private static void updateParamBindings(SimpleValueHandle paramBindingsPropHandle, String oldParamName, String newParamName) {
            if (paramBindingsPropHandle == null) {
                return;
            }
            Iterator bindingIter = paramBindingsPropHandle.iterator();
            while (bindingIter.hasNext()) {
                ParamBindingHandle bindingHandle = (ParamBindingHandle)bindingIter.next();
                if (!oldParamName.equals(bindingHandle.getParamName())) continue;
                bindingHandle.setParamName(newParamName);
            }
        }
    }
}

