/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript;

import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.postscript.device.PostscriptPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PostscriptRender
extends PageDeviceRender {
    private OutputStream output = null;
    private RenderOption renderOption = null;

    public PostscriptRender(IEmitterServices services) throws EngineException {
        this.initialize(services);
    }

    public IPageDevice createPageDevice(String title, String author, String subject, String description, IReportContext context, IReportContent report) {
        try {
            return new PostscriptPageDevice(this.renderOption, this.output, title, author, description);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    public String getDefaultOuputFile() {
        return "report.ps";
    }

    public String getOutputFormat() {
        return "postscript";
    }

    private void initialize(IEmitterServices services) throws EngineException {
        this.services = services;
        this.renderOption = (RenderOption)services.getRenderOption();
        IReportRunnable reportRunnable = services.getReportRunnable();
        if (reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)reportRunnable.getDesignHandle();
        }
        this.context = services.getReportContext();
        this.output = EmitterUtil.getOuputStream(services, "report.ps");
    }

    protected void newPage(IContainerArea page) {
        ContainerArea pageContainer;
        String orientation = null;
        if (page instanceof ContainerArea && (pageContainer = (ContainerArea)page).getContent() instanceof IPageContent) {
            IPageContent pageContent = (IPageContent)((ContainerArea)page).getContent();
            orientation = pageContent.getOrientation();
            ((PostscriptPageDevice)this.pageDevice).setOrientation(orientation);
        }
        super.newPage(page);
    }
}

