/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IEmitterDescriptor;

public abstract class AbstractEmitterDescriptor
implements IEmitterDescriptor {
    protected Map initParams = null;
    protected Locale locale;
    protected Properties defaultValues = null;
    protected IConfigurableOption[] options;
    private static final String OPTIONS_CONFIG_FILE = "RenderDefaults.cfg";

    public void setInitParameters(Map params) {
        this.initParams = params;
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            this.initOptions();
        }
    }

    public IConfigurableOptionObserver createOptionObserver() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getID() {
        return null;
    }

    protected abstract void initOptions();

    protected void applyDefaultValues() {
        IConfigurableOption[] iConfigurableOptionArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurableOption option = iConfigurableOptionArray[n2];
            this.applyDefaultValue(option);
            ++n2;
        }
    }

    protected boolean loadDefaultValues(String bundleName) {
        try {
            URL url = this.getConfigURL(bundleName);
            if (url != null) {
                InputStream in = url.openStream();
                this.defaultValues = new Properties();
                this.defaultValues.load(in);
                in.close();
                return true;
            }
        }
        catch (IOException iOException) {
            this.defaultValues = null;
            return false;
        }
        return false;
    }

    private void applyDefaultValue(IConfigurableOption option) {
        if (this.defaultValues == null || this.defaultValues.isEmpty()) {
            return;
        }
        String value = (String)this.defaultValues.get(option.getName());
        if (value != null) {
            ConfigurableOption optionImpl = (ConfigurableOption)option;
            switch (option.getDataType()) {
                case STRING: {
                    optionImpl.setDefaultValue(value);
                    break;
                }
                case BOOLEAN: {
                    optionImpl.setDefaultValue(Boolean.valueOf(value));
                    break;
                }
                case INTEGER: {
                    Integer intValue = null;
                    try {
                        intValue = Integer.decode(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                    optionImpl.setDefaultValue(intValue);
                    break;
                }
                case FLOAT: {
                    Float floatValue = null;
                    try {
                        floatValue = Float.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                    optionImpl.setDefaultValue(floatValue);
                    break;
                }
            }
        }
    }

    private URL getConfigURL(String bundleName) {
        IBundle bundle = Platform.getBundle(bundleName);
        if (bundle != null) {
            return bundle.getEntry(OPTIONS_CONFIG_FILE);
        }
        return null;
    }
}

