/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.olap;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.ITabularDimensionModel;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.TabularDimensionProvider;
import org.eclipse.birt.report.model.elements.strategy.TabularDimensionPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class TabularDimension
extends Dimension
implements ITabularDimensionModel {
    protected TabularDimensionProvider provider = null;

    public TabularDimension() {
        this(null);
    }

    public TabularDimension(String name) {
        super(name);
        this.cachedPropStrategy = TabularDimensionPropSearchStrategy.getInstance();
        this.provider = new TabularDimensionProvider(this);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitTabularDimension(this);
    }

    public String getElementName() {
        return "TabularDimension";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public TabularDimensionHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new TabularDimensionHandle(module, this);
        }
        return (TabularDimensionHandle)this.handle;
    }

    public DesignElement getSharedDimension(Module module) {
        ElementRefValue dataSetRef = (ElementRefValue)this.getProperty(module, "internalDimensionRef");
        if (dataSetRef == null) {
            return null;
        }
        return dataSetRef.getElement();
    }

    protected boolean isValidHierarchy(DesignElement hierarchy, Module module) {
        return hierarchy.getContainer() == this;
    }

    public boolean isManagedByNameSpace() {
        if (this.hasSharedDimension(this.getRoot())) {
            return false;
        }
        return super.isManagedByNameSpace();
    }

    protected Object baseClone() throws CloneNotSupportedException {
        TabularDimension clonedElement = (TabularDimension)super.baseClone();
        clonedElement.provider = new TabularDimensionProvider(clonedElement);
        clonedElement.provider.updateLayout(clonedElement.getRoot());
        return clonedElement;
    }

    public Object getLocalProperty(Module module, ElementPropertyDefn prop) {
        assert (prop != null);
        if (prop.getTypeCode() != 23) {
            return super.getLocalProperty(module, prop);
        }
        if (this.hasSharedDimension(module)) {
            return this.provider.getLayoutProperty(module, prop);
        }
        return super.getLocalProperty(module, prop);
    }

    public void setProperty(ElementPropertyDefn prop, Object value) {
        assert (prop != null);
        if (prop.getTypeCode() == 23 && this.hasSharedDimension(this.getRoot())) {
            this.provider.setLayoutProperty(prop, value);
        } else {
            if ("internalDimensionRef".equals(prop.getName())) {
                this.propValues.put("hierarchies", null);
                this.setProperty("defaultHierarchy", null);
            }
            super.setProperty(prop, value);
        }
    }

    public void updateLayout(Module module) {
        this.provider.updateLayout(module);
    }

    public boolean hasSharedDimension(Module module) {
        return this.getLocalProperty(module, "internalDimensionRef") != null;
    }

    public DesignElement getDynamicExtendsElement(Module module) {
        return this.getSharedDimension(module);
    }

    public boolean canDynamicExtends() {
        return this.hasSharedDimension(this.getRoot());
    }

    public DesignElement getDefaultHierarchy(Module module) {
        if (this.hasSharedDimension(module)) {
            String name = this.getStringProperty(module, "defaultHierarchy");
            return this.provider.findLocalElement(name, MetaDataDictionary.getInstance().getElement("Hierarchy"));
        }
        return super.getDefaultHierarchy(module);
    }

    public DesignElement getLocalHierarchy(Module module, String hierarchyName) {
        if (this.hasSharedDimension(module)) {
            return this.provider.findLocalElement(hierarchyName, MetaDataDictionary.getInstance().getElement("Hierarchy"));
        }
        return super.getLocalHierarchy(module, hierarchyName);
    }
}

