/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.script.IBaseDataSourceEventHandler;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IDataSourceEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IScriptedDataSetEventHandler;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.DtEScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptTextUtil;
import org.eclipse.birt.report.engine.script.internal.instance.DataSourceInstance;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.mozilla.javascript.Scriptable;

public class DataSourceScriptExecutor
extends DtEScriptExecutor
implements IBaseDataSourceEventHandler {
    protected DataSourceHandle dataSourceHandle;
    protected IDataSourceEventHandler eventHandler;
    private boolean useBeforeCloseEventHandler = false;
    private boolean useBeforeOpenEventHandler = false;
    private boolean useAfterOpenEventHandler = false;
    private boolean useAfterCloseEventHandler = false;
    private final String beforeOpenMethodID;
    private final String beforeCloseMethodID;
    private final String afterOpenMethodID;
    private final String afterCloseMethodID;

    public DataSourceScriptExecutor(DataSourceHandle dataSourceHandle, ExecutionContext context) throws BirtException {
        super(context);
        this.dataSourceHandle = dataSourceHandle;
        String className = dataSourceHandle.getEventHandlerClass();
        this.initEventHandler(className);
        this.useBeforeOpenEventHandler = ScriptTextUtil.isNullOrComments(dataSourceHandle.getBeforeOpen());
        this.useBeforeCloseEventHandler = ScriptTextUtil.isNullOrComments(dataSourceHandle.getBeforeClose());
        this.useAfterOpenEventHandler = ScriptTextUtil.isNullOrComments(dataSourceHandle.getAfterOpen());
        this.useAfterCloseEventHandler = ScriptTextUtil.isNullOrComments(dataSourceHandle.getAfterClose());
        this.beforeOpenMethodID = ModuleUtil.getScriptUID(dataSourceHandle.getPropertyHandle("beforeOpen"));
        this.beforeCloseMethodID = ModuleUtil.getScriptUID(dataSourceHandle.getPropertyHandle("beforeClose"));
        this.afterOpenMethodID = ModuleUtil.getScriptUID(dataSourceHandle.getPropertyHandle("afterOpen"));
        this.afterCloseMethodID = ModuleUtil.getScriptUID(dataSourceHandle.getPropertyHandle("afterClose"));
    }

    protected void initEventHandler(String className) {
        if (className != null) {
            try {
                this.eventHandler = (IDataSourceEventHandler)DataSourceScriptExecutor.getInstance(className, this.context);
            }
            catch (ClassCastException e) {
                DataSourceScriptExecutor.addClassCastException(this.context, e, this.dataSourceHandle, IScriptedDataSetEventHandler.class);
            }
            catch (EngineException e) {
                DataSourceScriptExecutor.addException(this.context, e, this.dataSourceHandle);
            }
        }
    }

    public void handleBeforeOpen(IDataSourceInstanceHandle dataSource) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.ScriptStatus status;
            if (!this.useBeforeOpenEventHandler && (status = this.handleJS(dataSource.getScriptScope(), dataSource.getName(), "beforeOpen", this.dataSourceHandle.getBeforeOpen(), this.beforeOpenMethodID)).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.beforeOpen(new DataSourceInstance(dataSource), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSourceScriptExecutor.addException(this.context, e);
        }
    }

    public void handleBeforeClose(IDataSourceInstanceHandle dataSource) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.ScriptStatus status;
            if (!this.useBeforeCloseEventHandler && (status = this.handleJS(dataSource.getScriptScope(), dataSource.getName(), "beforeClose", this.dataSourceHandle.getBeforeClose(), this.beforeCloseMethodID)).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.beforeClose(new DataSourceInstance(dataSource), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSourceScriptExecutor.addException(this.context, e);
        }
    }

    public void handleAfterOpen(IDataSourceInstanceHandle dataSource) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.ScriptStatus status;
            if (!this.useAfterOpenEventHandler && (status = this.handleJS(dataSource.getScriptScope(), dataSource.getName(), "afterOpen", this.dataSourceHandle.getAfterOpen(), this.afterOpenMethodID)).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.afterOpen(new DataSourceInstance(dataSource), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSourceScriptExecutor.addException(this.context, e);
        }
    }

    public void handleAfterClose(IDataSourceInstanceHandle dataSource) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.ScriptStatus status;
            if (!this.useAfterCloseEventHandler && (status = this.handleJS(dataSource.getScriptScope(), dataSource.getName(), "afterClose", this.dataSourceHandle.getAfterClose(), this.afterCloseMethodID)).didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.afterClose(this.reportContext);
            }
        }
        catch (Exception e) {
            DataSourceScriptExecutor.addException(this.context, e);
        }
    }

    protected ScriptExecutor.ScriptStatus handleJS(Scriptable scope, String name, String method, String script, String id) {
        return this.handleJS(scope, "DataSource", name, method, script, id);
    }
}

