/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.eclipse.birt.report.data.oda.i18n.JdbcResourceHandle;
import org.eclipse.birt.report.data.oda.jdbc.IConnectionFactory;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;

class JndiDataSource
implements IConnectionFactory {
    private static final String JNDI_PROPERTIES = "jndi.properties";
    private static final Logger sm_logger = Logger.getLogger(JndiDataSource.class.getName());
    private static final String sm_sourceClass = "JndiDataSource";
    private static JdbcResourceHandle sm_resourceHandle;

    JndiDataSource() {
    }

    public Connection getConnection(String driverClass, String jndiNameUrl, Properties connectionProperties) throws SQLException {
        sm_logger.entering(sm_sourceClass, "getConnection", jndiNameUrl);
        InitialContext initCtx = null;
        Object namedObject = null;
        try {
            try {
                initCtx = new InitialContext(this.getDriverJndiProperties());
                namedObject = initCtx.lookup(jndiNameUrl);
            }
            catch (Exception ex) {
                sm_logger.info(ex.toString());
                sm_logger.exiting(sm_sourceClass, "getConnection", null);
                SQLException sqlEx = new SQLException(ex.getLocalizedMessage());
                sqlEx.initCause(ex);
                throw sqlEx;
            }
        }
        catch (Throwable throwable) {
            this.closeContext(initCtx);
            throw throwable;
        }
        this.closeContext(initCtx);
        this.validateDataSourceType(namedObject, jndiNameUrl);
        Connection conn = this.getDataSourceConnection((DataSource)namedObject, connectionProperties);
        sm_logger.exiting(sm_sourceClass, "getConnection", conn);
        return conn;
    }

    private Connection getDataSourceConnection(DataSource ds, Properties connProps) throws SQLException {
        String username = connProps.getProperty("user");
        String password = connProps.getProperty("password");
        if (username != null && username.length() > 0) {
            if (sm_logger.isLoggable(Level.FINER)) {
                sm_logger.finer("getDataSourceConnection: using getConnection( username, password ) from data source pool.");
            }
            Connection conn = null;
            try {
                conn = ds.getConnection(username, password);
            }
            catch (SQLException ex) {
                sm_logger.info(ex.toString());
            }
            catch (UnsupportedOperationException unEx) {
                sm_logger.fine(unEx.toString());
            }
            if (conn != null) {
                return conn;
            }
        }
        if (sm_logger.isLoggable(Level.FINER)) {
            sm_logger.finer("getDataSourceConnection: using getConnection() from data source pool.");
        }
        return ds.getConnection();
    }

    private void validateDataSourceType(Object namedObject, String jndiNameUrl) throws SQLException {
        if (namedObject != null && namedObject instanceof DataSource) {
            return;
        }
        String localizedMsg = this.getMessage("odajdbc.GetConnectionError", jndiNameUrl);
        localizedMsg = String.valueOf(localizedMsg) + ". ";
        localizedMsg = String.valueOf(localizedMsg) + this.getMessage("odajdbc.jndi.InvalidJndiResource", namedObject != null ? namedObject.getClass().getName() : "null");
        if (sm_logger.isLoggable(Level.INFO)) {
            sm_logger.info(localizedMsg);
        }
        throw new SQLException(localizedMsg);
    }

    private void closeContext(Context ctx) {
        block3: {
            if (ctx == null) {
                return;
            }
            try {
                ctx.close();
            }
            catch (Exception e) {
                if (!sm_logger.isLoggable(Level.INFO)) break block3;
                sm_logger.info("closeContext(): " + e.toString());
            }
        }
    }

    protected Properties getDriverJndiProperties() {
        File jndiPropFile = this.getDriverJndiPropertyFile();
        if (jndiPropFile == null) {
            return null;
        }
        Properties jndiProps = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(jndiPropFile);
            jndiProps.load(inputStream);
        }
        catch (Exception ex) {
            if (sm_logger.isLoggable(Level.INFO)) {
                sm_logger.info("getDriverJndiProperties(): " + ex.toString());
            }
            jndiProps = null;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                if (sm_logger.isLoggable(Level.INFO)) {
                    sm_logger.info("getDriverJndiProperties(): " + e.toString());
                }
                inputStream = null;
            }
        }
        if (sm_logger.isLoggable(Level.CONFIG)) {
            int propertyCount = jndiProps == null ? 0 : jndiProps.size();
            sm_logger.config("Driver JNDI property count: " + propertyCount);
        }
        return jndiProps;
    }

    protected File getDriverJndiPropertyFile() {
        File driversDir = null;
        try {
            driversDir = OdaJdbcDriver.getDriverDirectory();
        }
        catch (OdaException ex) {
            sm_logger.info("getDriverJndiPropertyFile() " + ex.toString());
        }
        catch (IOException ioEx) {
            sm_logger.info("getDriverJndiPropertyFile() " + ioEx.toString());
        }
        if (driversDir == null || !driversDir.isDirectory()) {
            return null;
        }
        File jndiPropFile = new File(driversDir, JNDI_PROPERTIES);
        boolean canReadFile = false;
        try {
            canReadFile = jndiPropFile.isFile() && jndiPropFile.canRead();
        }
        catch (SecurityException e) {
            sm_logger.info("getDriverJndiPropertyFile() " + e.toString());
        }
        if (sm_logger.isLoggable(Level.CONFIG)) {
            sm_logger.config("getDriverJndiPropertyFile() " + jndiPropFile.getAbsolutePath() + " canReadFile = " + Boolean.valueOf(canReadFile));
        }
        return canReadFile ? jndiPropFile : null;
    }

    private String getMessage(String errorCode, String argument) {
        if (sm_resourceHandle == null) {
            sm_resourceHandle = new JdbcResourceHandle(ULocale.getDefault());
        }
        String msgText = sm_resourceHandle.getMessage(errorCode);
        if (argument == null) {
            return msgText;
        }
        return MessageFormat.format((String)msgText, (Object[])new Object[]{argument});
    }
}

