/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.driver;

import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.EdgeAxis;
import org.eclipse.birt.data.engine.olap.driver.IEdgeAxis;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;

public class CubeResultSet
implements IResultSet {
    private IEdgeAxis rowEdgeAxis;
    private IEdgeAxis columnEdgeAxis;
    private IEdgeAxis pageEdgeAxis;
    private IEdgeAxis[] calculatedEdgeAxis;
    private BirtCubeView cubeView;
    private IAggregationResultSet[] rsArray;
    private CubeQueryExecutorHelper cubeQueryExecutorHelper;

    public CubeResultSet(IAggregationResultSet[] rsArray, BirtCubeView view, CubeQueryExecutorHelper cubeQueryExecutorHelper) throws IOException {
        this.cubeView = view;
        this.rsArray = rsArray;
        this.cubeQueryExecutorHelper = cubeQueryExecutorHelper;
        this.populateEdge();
    }

    public CubeResultSet(IResultSet resultSet, BirtCubeView view, CubeQueryExecutorHelper cubeQueryExcutorHelper, int startingColumnIndex, int startingRowIndex) throws IOException {
        this.cubeView = view;
        this.populateEdgeOnSubQuery(resultSet, cubeQueryExcutorHelper, startingColumnIndex, startingRowIndex);
    }

    private void populateEdge() throws IOException {
        int count = 0;
        if (this.cubeView.getColumnEdgeView() != null) {
            this.columnEdgeAxis = new EdgeAxis(this.rsArray[count], this.cubeView.getColumnEdgeView(), this.cubeQueryExecutorHelper.getColumnSort(), false);
            this.cubeView.getColumnEdgeView().setEdgeAxis(this.columnEdgeAxis);
            ++count;
        }
        if (this.cubeView.getRowEdgeView() != null) {
            this.rowEdgeAxis = new EdgeAxis(this.rsArray[count], this.cubeView.getRowEdgeView(), this.cubeQueryExecutorHelper.getRowSort(), false);
            this.cubeView.getRowEdgeView().setEdgeAxis(this.rowEdgeAxis);
            ++count;
        }
        if (this.cubeView.getPageEdgeView() != null) {
            this.pageEdgeAxis = new EdgeAxis(this.rsArray[count], this.cubeView.getPageEdgeView(), this.cubeQueryExecutorHelper.getPageSort(), false);
            this.cubeView.getPageEdgeView().setEdgeAxis(this.pageEdgeAxis);
            ++count;
        }
        if (this.rsArray.length > count) {
            this.calculatedEdgeAxis = new EdgeAxis[this.rsArray.length - count];
            int i = count;
            while (i < this.rsArray.length) {
                this.calculatedEdgeAxis[i - count] = new EdgeAxis(this.rsArray[i], this.cubeView.getMeasureEdgeView()[i - count], true);
                ++i;
            }
        }
    }

    private void populateEdgeOnSubQuery(IResultSet parentResult, CubeQueryExecutorHelper cubeQueryExcutorHelper, int startingColumnIndex, int startingRowIndex) throws IOException {
        this.cubeQueryExecutorHelper = cubeQueryExcutorHelper;
        if (this.cubeView.getColumnEdgeView() != null) {
            this.columnEdgeAxis = new EdgeAxis(parentResult.getColumnEdgeResult().getRowDataAccessor(), this.cubeView.getColumnEdgeView(), cubeQueryExcutorHelper.getColumnSort(), false, startingColumnIndex);
        }
        if (this.cubeView.getRowEdgeView() != null) {
            this.rowEdgeAxis = new EdgeAxis(parentResult.getRowEdgeResult().getRowDataAccessor(), this.cubeView.getRowEdgeView(), cubeQueryExcutorHelper.getRowSort(), false, startingRowIndex);
        }
        this.calculatedEdgeAxis = parentResult.getMeasureResult();
    }

    public IEdgeAxis getColumnEdgeResult() {
        return this.columnEdgeAxis;
    }

    public IEdgeAxis getRowEdgeResult() {
        return this.rowEdgeAxis;
    }

    public IEdgeAxis getPageEdgeResult() {
        return this.pageEdgeAxis;
    }

    public IEdgeAxis[] getMeasureResult() {
        return this.calculatedEdgeAxis;
    }

    public IEdgeAxis getMeasureResult(String name) throws DataException {
        int index = this.cubeView.getAggregationRegisterTable().getAggregationResultID(name);
        return this.calculatedEdgeAxis[index];
    }
}

