/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;

public class FactTableRowIteratorWithFilter
implements IFactTableRowIterator {
    private DimensionResultIterator[] dimesionResultIterators;
    private IFactTableRowIterator facttableRowIterator;
    private int[] currentPos = null;
    private Object[] currentMeasures;
    private IDimension[] dimensions;

    public FactTableRowIteratorWithFilter(IDimension[] dimensions, IFactTableRowIterator facttableRowIterator, StopSign stopSign) throws IOException {
        this.dimensions = dimensions;
        this.dimesionResultIterators = this.getDimesionResultIterators(stopSign);
        this.facttableRowIterator = facttableRowIterator;
        this.currentPos = new int[this.dimesionResultIterators.length];
        this.currentMeasures = new Object[facttableRowIterator.getMeasureCount()];
    }

    private DimensionResultIterator[] getDimesionResultIterators(StopSign stopSign) throws IOException {
        DimensionResultIterator[] dimesionResultIterators = new DimensionResultIterator[this.dimensions.length];
        int i = 0;
        while (i < this.dimensions.length) {
            dimesionResultIterators[i] = new DimensionResultIterator((Dimension)this.dimensions[i], this.dimensions[i].findAll(), stopSign);
            ++i;
        }
        return dimesionResultIterators;
    }

    public int getDimensionCount() {
        return this.dimensions.length;
    }

    public int getDimensionIndex(String dimensionName) {
        int i = 0;
        while (i < this.dimensions.length) {
            if (this.dimensions[i].getName().equals(dimensionName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getDimensionPosition(int dimensionIndex) {
        return this.currentPos[dimensionIndex];
    }

    public int[] getDimensionPosition() {
        return this.currentPos;
    }

    public Object getMeasure(int measureIndex) {
        return this.currentMeasures[measureIndex];
    }

    public int getMeasureCount() {
        return this.currentMeasures.length;
    }

    public int getMeasureIndex(String measureName) {
        return this.facttableRowIterator.getMeasureIndex(measureName);
    }

    public boolean next() throws IOException, DataException {
        boolean hasNext = this.facttableRowIterator.next();
        while (hasNext) {
            int i = 0;
            while (i < this.currentPos.length) {
                this.currentPos[i] = this.facttableRowIterator.getDimensionPosition(i);
                ++i;
            }
            i = 0;
            while (i < this.currentMeasures.length) {
                this.currentMeasures[i] = this.facttableRowIterator.getMeasure(i);
                ++i;
            }
            if (this.filter()) break;
            hasNext = this.facttableRowIterator.next();
        }
        return hasNext;
    }

    private boolean filter() throws IOException {
        DimensionRow[] dimRows = new DimensionRow[this.currentPos.length];
        int i = 0;
        while (i < this.currentPos.length) {
            this.dimesionResultIterators[i].seek(this.currentPos[i]);
            dimRows[i] = this.dimesionResultIterators[i].getDimensionRow();
            ++i;
        }
        return true;
    }

    public MeasureInfo[] getMeasureInfos() {
        return this.facttableRowIterator.getMeasureInfos();
    }

    public void close() throws DataException, IOException {
        this.facttableRowIterator.close();
    }
}

