/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.document.CacheProvider;
import org.eclipse.birt.data.engine.impl.document.IRDGroupUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

abstract class BaseCachedResultSet
implements CacheProvider,
IResultIterator {
    private int currRowIndex = -1;
    protected int rowCount;
    protected IResultClass resultClass;
    protected ResultSetCache smartCache;
    protected IRDGroupUtil rdGroupUtil;

    BaseCachedResultSet() {
    }

    public IResultClass getResultClass() throws DataException {
        return this.resultClass;
    }

    public int getRowCount() throws DataException {
        return this.rowCount;
    }

    public boolean next() throws DataException {
        boolean hasNext = this.smartCache.next();
        this.currRowIndex = hasNext ? ++this.currRowIndex : -1;
        if (this.rdGroupUtil != null) {
            this.rdGroupUtil.next(hasNext);
        }
        return hasNext;
    }

    public IResultObject getCurrentResult() throws DataException {
        return this.smartCache.getCurrentResult();
    }

    public int getCurrentResultIndex() throws DataException {
        if (this.getCurrentResult() != null) {
            return this.currRowIndex;
        }
        return -1;
    }

    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        return this.rdGroupUtil.getCurrentGroupIndex(groupLevel);
    }

    public int getStartingGroupLevel() throws DataException {
        return this.rdGroupUtil.getStartingGroupLevel();
    }

    public int getEndingGroupLevel() throws DataException {
        return this.rdGroupUtil.getEndingGroupLevel();
    }

    public void first(int groupingLevel) throws DataException {
        throw new DataException("data.engine.unsupportOperationException");
    }

    public void last(int groupingLevel) throws DataException {
        this.rdGroupUtil.last(groupingLevel);
    }

    public void close() throws DataException {
        this.smartCache.close();
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return this.rdGroupUtil.getGroupStartAndEndIndex(groupLevel);
    }

    public ResultSetCache getResultSetCache() {
        return this.smartCache;
    }

    public int getCount() {
        return this.rowCount;
    }

    public int getCurrentIndex() {
        return this.currRowIndex;
    }

    public void moveTo(int destIndex) throws DataException {
        assert (destIndex >= this.currRowIndex);
        int forwardSteps = destIndex - this.currRowIndex;
        int i = 0;
        while (i < forwardSteps) {
            this.next();
            ++i;
        }
    }

    public IExecutorHelper getExecutorHelper() {
        return null;
    }

    public Object getAggrValue(String aggrName) throws DataException {
        throw new UnsupportedOperationException();
    }
}

