/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute.impl;

import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.eclipse.birt.chart.internal.model.Fraction;
import org.eclipse.birt.chart.internal.model.FractionApproximator;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.impl.FormatSpecifierImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class FractionNumberFormatSpecifierImpl
extends FormatSpecifierImpl
implements FractionNumberFormatSpecifier {
    protected static final boolean PRECISE_EDEFAULT = false;
    protected boolean precise = false;
    protected boolean preciseESet;
    protected static final int FRACTION_DIGITS_EDEFAULT = 0;
    protected int fractionDigits = 0;
    protected boolean fractionDigitsESet;
    protected static final double NUMERATOR_EDEFAULT = 0.0;
    protected double numerator = 0.0;
    protected boolean numeratorESet;
    protected static final String PREFIX_EDEFAULT = null;
    protected String prefix = PREFIX_EDEFAULT;
    protected static final String SUFFIX_EDEFAULT = null;
    protected String suffix = SUFFIX_EDEFAULT;
    protected static final String DELIMITER_EDEFAULT = "/";
    protected String delimiter = "/";
    protected boolean delimiterESet;

    protected FractionNumberFormatSpecifierImpl() {
    }

    protected EClass eStaticClass() {
        return AttributePackage.Literals.FRACTION_NUMBER_FORMAT_SPECIFIER;
    }

    public boolean isPrecise() {
        return this.precise;
    }

    public void setPrecise(boolean newPrecise) {
        boolean oldPrecise = this.precise;
        this.precise = newPrecise;
        boolean oldPreciseESet = this.preciseESet;
        this.preciseESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldPrecise, this.precise, !oldPreciseESet));
        }
    }

    public void unsetPrecise() {
        boolean oldPrecise = this.precise;
        boolean oldPreciseESet = this.preciseESet;
        this.precise = false;
        this.preciseESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 0, oldPrecise, false, oldPreciseESet));
        }
    }

    public boolean isSetPrecise() {
        return this.preciseESet;
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    public void setFractionDigits(int newFractionDigits) {
        int oldFractionDigits = this.fractionDigits;
        this.fractionDigits = newFractionDigits;
        boolean oldFractionDigitsESet = this.fractionDigitsESet;
        this.fractionDigitsESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldFractionDigits, this.fractionDigits, !oldFractionDigitsESet));
        }
    }

    public void unsetFractionDigits() {
        int oldFractionDigits = this.fractionDigits;
        boolean oldFractionDigitsESet = this.fractionDigitsESet;
        this.fractionDigits = 0;
        this.fractionDigitsESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 1, oldFractionDigits, 0, oldFractionDigitsESet));
        }
    }

    public boolean isSetFractionDigits() {
        return this.fractionDigitsESet;
    }

    public double getNumerator() {
        return this.numerator;
    }

    public void setNumerator(double newNumerator) {
        double oldNumerator = this.numerator;
        this.numerator = newNumerator;
        boolean oldNumeratorESet = this.numeratorESet;
        this.numeratorESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldNumerator, this.numerator, !oldNumeratorESet));
        }
    }

    public void unsetNumerator() {
        double oldNumerator = this.numerator;
        boolean oldNumeratorESet = this.numeratorESet;
        this.numerator = 0.0;
        this.numeratorESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 2, oldNumerator, 0.0, oldNumeratorESet));
        }
    }

    public boolean isSetNumerator() {
        return this.numeratorESet;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String newPrefix) {
        String oldPrefix = this.prefix;
        this.prefix = newPrefix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldPrefix, (Object)this.prefix));
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String newSuffix) {
        String oldSuffix = this.suffix;
        this.suffix = newSuffix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSuffix, (Object)this.suffix));
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String newDelimiter) {
        String oldDelimiter = this.delimiter;
        this.delimiter = newDelimiter;
        boolean oldDelimiterESet = this.delimiterESet;
        this.delimiterESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldDelimiter, (Object)this.delimiter, !oldDelimiterESet));
        }
    }

    public void unsetDelimiter() {
        String oldDelimiter = this.delimiter;
        boolean oldDelimiterESet = this.delimiterESet;
        this.delimiter = DELIMITER_EDEFAULT;
        this.delimiterESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, (Object)oldDelimiter, (Object)DELIMITER_EDEFAULT, oldDelimiterESet));
        }
    }

    public boolean isSetDelimiter() {
        return this.delimiterESet;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isPrecise();
            }
            case 1: {
                return this.getFractionDigits();
            }
            case 2: {
                return this.getNumerator();
            }
            case 3: {
                return this.getPrefix();
            }
            case 4: {
                return this.getSuffix();
            }
            case 5: {
                return this.getDelimiter();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPrecise((Boolean)newValue);
                return;
            }
            case 1: {
                this.setFractionDigits((Integer)newValue);
                return;
            }
            case 2: {
                this.setNumerator((Double)newValue);
                return;
            }
            case 3: {
                this.setPrefix((String)newValue);
                return;
            }
            case 4: {
                this.setSuffix((String)newValue);
                return;
            }
            case 5: {
                this.setDelimiter((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.unsetPrecise();
                return;
            }
            case 1: {
                this.unsetFractionDigits();
                return;
            }
            case 2: {
                this.unsetNumerator();
                return;
            }
            case 3: {
                this.setPrefix(PREFIX_EDEFAULT);
                return;
            }
            case 4: {
                this.setSuffix(SUFFIX_EDEFAULT);
                return;
            }
            case 5: {
                this.unsetDelimiter();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.isSetPrecise();
            }
            case 1: {
                return this.isSetFractionDigits();
            }
            case 2: {
                return this.isSetNumerator();
            }
            case 3: {
                return PREFIX_EDEFAULT == null ? this.prefix != null : !PREFIX_EDEFAULT.equals(this.prefix);
            }
            case 4: {
                return SUFFIX_EDEFAULT == null ? this.suffix != null : !SUFFIX_EDEFAULT.equals(this.suffix);
            }
            case 5: {
                return this.isSetDelimiter();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (precise: ");
        if (this.preciseESet) {
            result.append(this.precise);
        } else {
            result.append("<unset>");
        }
        result.append(", fractionDigits: ");
        if (this.fractionDigitsESet) {
            result.append(this.fractionDigits);
        } else {
            result.append("<unset>");
        }
        result.append(", numerator: ");
        if (this.numeratorESet) {
            result.append(this.numerator);
        } else {
            result.append("<unset>");
        }
        result.append(", prefix: ");
        result.append(this.prefix);
        result.append(", suffix: ");
        result.append(this.suffix);
        result.append(", delimiter: ");
        if (this.delimiterESet) {
            result.append(this.delimiter);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public static FractionNumberFormatSpecifier create() {
        FractionNumberFormatSpecifier nfs = AttributeFactory.eINSTANCE.createFractionNumberFormatSpecifier();
        nfs.setPrecise(true);
        nfs.setFractionDigits(3);
        return nfs;
    }

    public String format(double dValue, Locale lo) {
        return this.format(dValue, ULocale.forLocale((Locale)lo));
    }

    public String format(double dValue, ULocale lo) {
        Fraction fraction = null;
        fraction = this.isPrecise() ? FractionApproximator.getExactFraction(dValue) : (this.getNumerator() > 0.0 ? FractionApproximator.getFractionWithNumerator(dValue, (int)this.getNumerator()) : FractionApproximator.getFractionWithMaxDigits(dValue, this.getFractionDigits()));
        StringBuffer sb = new StringBuffer();
        if (this.getPrefix() != null) {
            sb.append(this.getPrefix());
        }
        sb.append(fraction.toString(this.getDelimiter()));
        if (this.getSuffix() != null) {
            sb.append(this.getSuffix());
        }
        return sb.toString();
    }

    public FractionNumberFormatSpecifier copyInstance() {
        FractionNumberFormatSpecifierImpl dest = new FractionNumberFormatSpecifierImpl();
        dest.set(this);
        return dest;
    }

    protected void set(FractionNumberFormatSpecifier src) {
        super.set(src);
        this.precise = src.isPrecise();
        this.preciseESet = src.isSetPrecise();
        this.fractionDigits = src.getFractionDigits();
        this.fractionDigitsESet = src.isSetFractionDigits();
        this.numerator = src.getNumerator();
        this.numeratorESet = src.isSetNumerator();
        this.prefix = src.getPrefix();
        this.suffix = src.getSuffix();
        this.delimiter = src.getDelimiter();
        this.delimiterESet = src.isSetDelimiter();
    }
}

