/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Cons;
import clojure.lang.Counted;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class ASeq
extends Obj
implements ISeq,
Sequential,
List,
Serializable {
    transient int _hash = -1;

    public String toString() {
        return RT.printString(this);
    }

    public IPersistentCollection empty() {
        return PersistentList.EMPTY;
    }

    protected ASeq(IPersistentMap meta2) {
        super(meta2);
    }

    protected ASeq() {
    }

    public boolean equiv(Object obj) {
        if (!(obj instanceof Sequential) && !(obj instanceof List)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        ISeq s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equiv(s.first(), ms.first())) {
                return false;
            }
            s = s.next();
            ms = ms.next();
        }
        return ms == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sequential) && !(obj instanceof List)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        ISeq s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equals(s.first(), ms.first())) {
                return false;
            }
            s = s.next();
            ms = ms.next();
        }
        return ms == null;
    }

    public int hashCode() {
        if (this._hash == -1) {
            int hash2 = 1;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                hash2 = 31 * hash2 + (s.first() == null ? 0 : s.first().hashCode());
            }
            this._hash = hash2;
        }
        return this._hash;
    }

    public int count() {
        int i = 1;
        ISeq s = this.next();
        while (s != null) {
            if (s instanceof Counted) {
                return i + s.count();
            }
            s = s.next();
            ++i;
        }
        return i;
    }

    public final ISeq seq() {
        return this;
    }

    public ISeq cons(Object o) {
        return new Cons(o, this);
    }

    public ISeq more() {
        ISeq s = this.next();
        if (s == null) {
            return PersistentList.EMPTY;
        }
        return s;
    }

    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray(Object[] a) {
        if (a.length >= this.count()) {
            int i = 0;
            for (ISeq s = this.seq(); s != null; s = s.next()) {
                a[i] = s.first();
                ++i;
            }
            if (a.length > this.count()) {
                a[this.count()] = null;
            }
            return a;
        }
        return this.toArray();
    }

    public int size() {
        return this.count();
    }

    public boolean isEmpty() {
        return this.seq() == null;
    }

    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new SeqIterator(this);
    }

    private List reify() {
        return Collections.unmodifiableList(new ArrayList(this));
    }

    public List subList(int fromIndex, int toIndex) {
        return this.reify().subList(fromIndex, toIndex);
    }

    public Object set(int index2, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index2) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object o) {
        ISeq s = this.seq();
        int i = 0;
        while (s != null) {
            if (Util.equiv(s.first(), o)) {
                return i;
            }
            s = s.next();
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        return this.reify().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.reify().listIterator();
    }

    public ListIterator listIterator(int index2) {
        return this.reify().listIterator(index2);
    }

    public Object get(int index2) {
        return RT.nth(this, index2);
    }

    public void add(int index2, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index2, Collection c) {
        throw new UnsupportedOperationException();
    }
}

