/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.variable.impl.type;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.type.AbstractValueTypeImpl;
import org.camunda.bpm.engine.variable.type.FileValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.engine.variable.value.builder.FileValueBuilder;

public class FileValueTypeImpl
extends AbstractValueTypeImpl
implements FileValueType {
    private static final long serialVersionUID = 1L;

    public FileValueTypeImpl() {
        super("file");
    }

    @Override
    public TypedValue createValue(Object value, Map<String, Object> valueInfo) {
        Object filename = valueInfo.get("filename");
        if (filename == null) {
            throw new IllegalArgumentException("Cannot create file without filename! Please set a name into ValueInfo with key filename");
        }
        FileValueBuilder builder = Variables.fileValue(filename.toString());
        if (value instanceof File) {
            builder.file((File)value);
        } else if (value instanceof InputStream) {
            builder.file((InputStream)value);
        } else if (value instanceof byte[]) {
            builder.file((byte[])value);
        } else {
            throw new IllegalArgumentException("Provided value is not of File, InputStream or byte[] type.");
        }
        if (valueInfo.containsKey("mimeType")) {
            Object mimeType = valueInfo.get("mimeType");
            if (mimeType == null) {
                throw new IllegalArgumentException("The provided mime type is null. Set a non-null value info property with key 'filename'");
            }
            builder.mimeType(mimeType.toString());
        }
        if (valueInfo.containsKey("encoding")) {
            Object encoding = valueInfo.get("encoding");
            if (encoding == null) {
                throw new IllegalArgumentException("The provided encoding is null. Set a non-null value info property with key 'encoding'");
            }
            builder.encoding(encoding.toString());
        }
        return builder.create();
    }

    @Override
    public Map<String, Object> getValueInfo(TypedValue typedValue) {
        if (!(typedValue instanceof FileValue)) {
            throw new IllegalArgumentException("Value not of type FileValue");
        }
        FileValue fileValue = (FileValue)typedValue;
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("filename", fileValue.getFilename());
        if (fileValue.getMimeType() != null) {
            result.put("mimeType", fileValue.getMimeType());
        }
        if (fileValue.getEncoding() != null) {
            result.put("encoding", fileValue.getEncoding());
        }
        return result;
    }

    @Override
    public boolean isPrimitiveValueType() {
        return true;
    }
}

