/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatistics;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatisticsQuery;
import org.camunda.bpm.engine.impl.HistoricCaseActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.CleanableHistoricCaseInstanceReportDto;
import org.camunda.bpm.engine.rest.dto.history.CleanableHistoricCaseInstanceReportResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricCaseActivityStatisticsDto;
import org.camunda.bpm.engine.rest.history.HistoricCaseDefinitionRestService;

public class HistoricCaseDefinitionRestServiceImpl
implements HistoricCaseDefinitionRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricCaseDefinitionRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public List<HistoricCaseActivityStatisticsDto> getHistoricCaseActivityStatistics(String caseDefinitionId) {
        HistoryService historyService = this.processEngine.getHistoryService();
        HistoricCaseActivityStatisticsQuery historicCaseActivityStatisticsQuery = historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        List statistics = ((HistoricCaseActivityStatisticsQueryImpl)historicCaseActivityStatisticsQuery).unboundedResultList();
        ArrayList<HistoricCaseActivityStatisticsDto> result = new ArrayList<HistoricCaseActivityStatisticsDto>();
        for (HistoricCaseActivityStatistics currentStatistics : statistics) {
            result.add(HistoricCaseActivityStatisticsDto.fromHistoricCaseActivityStatistics(currentStatistics));
        }
        return result;
    }

    @Override
    public List<CleanableHistoricCaseInstanceReportResultDto> getCleanableHistoricCaseInstanceReport(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CleanableHistoricCaseInstanceReportDto queryDto = new CleanableHistoricCaseInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        CleanableHistoricCaseInstanceReport query = (CleanableHistoricCaseInstanceReport)queryDto.toQuery(this.processEngine);
        List<CleanableHistoricCaseInstanceReportResult> reportResult = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        return CleanableHistoricCaseInstanceReportResultDto.convert(reportResult);
    }

    private List<CleanableHistoricCaseInstanceReportResult> executePaginatedQuery(CleanableHistoricCaseInstanceReport query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getCleanableHistoricCaseInstanceReportCount(UriInfo uriInfo) {
        CleanableHistoricCaseInstanceReportDto queryDto = new CleanableHistoricCaseInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        queryDto.setObjectMapper(this.objectMapper);
        CleanableHistoricCaseInstanceReport query = (CleanableHistoricCaseInstanceReport)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

