/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ibatis.exceptions.PersistenceException;
import org.camunda.bpm.application.InvocationContext;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.interceptor.AtomicOperationInvocation;
import org.camunda.bpm.engine.impl.interceptor.BpmnStackTrace;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;

public class CommandInvocationContext {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected Throwable throwable;
    protected Command<?> command;
    protected boolean isExecuting = false;
    protected List<AtomicOperationInvocation> queuedInvocations = new ArrayList<AtomicOperationInvocation>();
    protected BpmnStackTrace bpmnStackTrace = new BpmnStackTrace();

    public CommandInvocationContext(Command<?> command) {
        this.command = command;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public void trySetThrowable(Throwable t) {
        if (this.throwable == null) {
            this.throwable = t;
        } else {
            LOG.maskedExceptionInCommandContext(this.throwable);
        }
    }

    public void performOperation(AtomicOperation executionOperation, ExecutionEntity execution) {
        this.performOperation(executionOperation, execution, false);
    }

    public void performOperationAsync(AtomicOperation executionOperation, ExecutionEntity execution) {
        this.performOperation(executionOperation, execution, true);
    }

    public void performOperation(AtomicOperation executionOperation, ExecutionEntity execution, boolean performAsync) {
        AtomicOperationInvocation invocation = new AtomicOperationInvocation(executionOperation, execution, performAsync);
        this.queuedInvocations.add(0, invocation);
        this.performNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performNext() {
        AtomicOperationInvocation nextInvocation = this.queuedInvocations.get(0);
        if (nextInvocation.operation.isAsyncCapable() && this.isExecuting) {
            return;
        }
        ProcessApplicationReference targetProcessApplication = this.getTargetProcessApplication(nextInvocation.execution);
        if (this.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CommandInvocationContext.this.performNext();
                    return null;
                }
            }, targetProcessApplication, new InvocationContext(nextInvocation.execution));
        } else if (!nextInvocation.operation.isAsyncCapable()) {
            this.invokeNext();
        } else {
            try {
                this.isExecuting = true;
                while (!this.queuedInvocations.isEmpty()) {
                    nextInvocation = this.queuedInvocations.get(0);
                    this.invokeNext();
                }
            }
            finally {
                this.isExecuting = false;
            }
        }
    }

    protected void invokeNext() {
        AtomicOperationInvocation invocation = this.queuedInvocations.remove(0);
        try {
            invocation.execute(this.bpmnStackTrace);
        }
        catch (RuntimeException e) {
            this.bpmnStackTrace.printStackTrace(Context.getProcessEngineConfiguration().isBpmnStacktraceVerbose());
            throw e;
        }
    }

    protected boolean requiresContextSwitch(ProcessApplicationReference processApplicationReference) {
        return ProcessApplicationContextUtil.requiresContextSwitch(processApplicationReference);
    }

    protected ProcessApplicationReference getTargetProcessApplication(ExecutionEntity execution) {
        return ProcessApplicationContextUtil.getTargetProcessApplication(execution);
    }

    public void rethrow() {
        if (this.throwable != null) {
            if (this.throwable instanceof Error) {
                throw (Error)this.throwable;
            }
            if (this.throwable instanceof PersistenceException) {
                throw new ProcessEngineException("Process engine persistence exception", this.throwable);
            }
            if (this.throwable instanceof RuntimeException) {
                throw (RuntimeException)this.throwable;
            }
            throw new ProcessEngineException("exception while executing command " + this.command, this.throwable);
        }
    }
}

