/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class UpdateDecisionDefinitionHistoryTimeToLiveCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String decisionDefinitionId;
    protected Integer historyTimeToLive;

    public UpdateDecisionDefinitionHistoryTimeToLiveCmd(String decisionDefinitionId, Integer historyTimeToLive) {
        this.decisionDefinitionId = decisionDefinitionId;
        this.historyTimeToLive = historyTimeToLive;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.checkAuthorization(commandContext);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "decisionDefinitionId", (Object)this.decisionDefinitionId);
        if (this.historyTimeToLive != null) {
            EnsureUtil.ensureGreaterThanOrEqual(BadUserRequestException.class, "", "historyTimeToLive", this.historyTimeToLive.intValue(), 0L);
        }
        DecisionDefinitionEntity decisionDefinitionEntity = commandContext.getDecisionDefinitionManager().findDecisionDefinitionById(this.decisionDefinitionId);
        decisionDefinitionEntity.setHistoryTimeToLive(this.historyTimeToLive);
        return null;
    }

    protected void checkAuthorization(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateDecisionDefinitionById(this.decisionDefinitionId);
        }
    }
}

