/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupContext;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.runtime.Job;

public class HistoryCleanupCmd
implements Command<Job> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    public static final JobDeclaration HISTORY_CLEANUP_JOB_DECLARATION = new HistoryCleanupJobDeclaration();
    private boolean immediatelyDue;

    public HistoryCleanupCmd(boolean immediatelyDue) {
        this.immediatelyDue = immediatelyDue;
    }

    @Override
    public Job execute(CommandContext commandContext) {
        boolean suspendJob;
        JobEntity historyCleanupJob;
        commandContext.getAuthorizationManager().checkCamundaAdmin();
        if (!this.willBeScheduled(commandContext)) {
            LOG.debugHistoryCleanupWrongConfiguration();
        }
        boolean createJob = (historyCleanupJob = commandContext.getJobManager().findJobByHandlerType("history-cleanup")) == null && this.willBeScheduled(commandContext);
        boolean reconfigureJob = historyCleanupJob != null && this.willBeScheduled(commandContext);
        boolean bl = suspendJob = historyCleanupJob != null && !this.willBeScheduled(commandContext);
        if (createJob) {
            commandContext.getPropertyManager().acquireExclusiveLockForHistoryCleanupJob();
            historyCleanupJob = commandContext.getJobManager().findJobByHandlerType("history-cleanup");
            if (historyCleanupJob == null) {
                historyCleanupJob = HISTORY_CLEANUP_JOB_DECLARATION.createJobInstance(new HistoryCleanupContext(this.immediatelyDue));
                Context.getCommandContext().getJobManager().insertAndHintJobExecutor(historyCleanupJob);
            }
        } else if (reconfigureJob) {
            HistoryCleanupContext historyCleanupContext = new HistoryCleanupContext(this.immediatelyDue);
            HISTORY_CLEANUP_JOB_DECLARATION.reconfigure(historyCleanupContext, historyCleanupJob);
            Date newDueDate = HISTORY_CLEANUP_JOB_DECLARATION.resolveDueDate(historyCleanupContext);
            commandContext.getJobManager().reschedule(historyCleanupJob, newDueDate);
        } else if (suspendJob) {
            historyCleanupJob.setDuedate(null);
            historyCleanupJob.setSuspensionState(SuspensionState.SUSPENDED.getStateCode());
        }
        return historyCleanupJob;
    }

    private boolean willBeScheduled(CommandContext commandContext) {
        return this.immediatelyDue || HistoryCleanupHelper.isBatchWindowConfigured(commandContext);
    }
}

