/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricProcessInstancesCmd
implements Command<Void>,
Serializable {
    protected final List<String> processInstanceIds;

    public DeleteHistoricProcessInstancesCmd(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceIds", this.processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "processInstanceId is null", "processInstanceIds", this.processInstanceIds);
        List<HistoricProcessInstance> instances = commandContext.runWithoutAuthorization(new Callable<List<HistoricProcessInstance>>(){

            @Override
            public List<HistoricProcessInstance> call() throws Exception {
                return new HistoricProcessInstanceQueryImpl().processInstanceIds(new HashSet<String>(DeleteHistoricProcessInstancesCmd.this.processInstanceIds)).list();
            }
        });
        if (this.processInstanceIds.size() == 1) {
            EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "No historic process instance found with id: " + this.processInstanceIds.get(0), "historicProcessInstanceIds", instances);
        } else {
            EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "No historic process instances found", "historicProcessInstanceIds", instances);
        }
        ArrayList<String> existingIds = new ArrayList<String>();
        for (HistoricProcessInstance historicProcessInstance : instances) {
            existingIds.add(historicProcessInstance.getId());
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkDeleteHistoricProcessInstance(historicProcessInstance);
            }
            EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process instance is still running, cannot delete historic process instance: " + historicProcessInstance, "instance.getEndTime()", (Object)historicProcessInstance.getEndTime());
        }
        ArrayList<String> nonExistingIds = new ArrayList<String>(this.processInstanceIds);
        nonExistingIds.removeAll(existingIds);
        EnsureUtil.ensureNumberOfElements(BadUserRequestException.class, "No historic process instances found with ids " + nonExistingIds, "nonExistingIds", nonExistingIds, 0);
        commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByIds(this.processInstanceIds);
        return null;
    }
}

