/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.SetRetriesBatchConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.batch.AbstractIDBasedBatchCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractSetJobsRetriesBatchCmd
extends AbstractIDBasedBatchCmd<Batch> {
    protected int retries;

    @Override
    public Batch execute(CommandContext commandContext) {
        List<String> jobIds = this.collectJobIds(commandContext);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "jobIds", jobIds);
        EnsureUtil.ensureGreaterThanOrEqual("Retries count", this.retries, 0L);
        this.checkAuthorizations(commandContext);
        this.writeUserOperationLog(commandContext, this.retries, jobIds.size(), true);
        BatchEntity batch = this.createBatch(commandContext, jobIds);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int retries, int numInstances, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        propertyChanges.add(new PropertyChange("retries", null, retries));
        commandContext.getOperationLogManager().logProcessInstanceOperation("SetJobRetries", null, null, null, propertyChanges);
    }

    protected abstract List<String> collectJobIds(CommandContext var1);

    @Override
    protected SetRetriesBatchConfiguration getAbstractIdsBatchConfiguration(List<String> ids) {
        return new SetRetriesBatchConfiguration(ids, this.retries);
    }

    @Override
    protected BatchJobHandler<SetRetriesBatchConfiguration> getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("set-job-retries");
    }
}

