/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;

public class IntermediateThrowSignalEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected final EventSubscriptionDeclaration signalDefinition;

    public IntermediateThrowSignalEventActivityBehavior(EventSubscriptionDeclaration signalDefinition) {
        this.signalDefinition = signalDefinition;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        List<SignalEventSubscriptionEntity> signalEventSubscriptions = this.findSignalEventSubscriptions(this.signalDefinition.getEventName(), execution.getTenantId());
        for (SignalEventSubscriptionEntity signalEventSubscription : signalEventSubscriptions) {
            if (!this.isActiveEventSubscription(signalEventSubscription)) continue;
            signalEventSubscription.eventReceived(null, this.signalDefinition.isAsync());
        }
        this.leave(execution);
    }

    protected List<SignalEventSubscriptionEntity> findSignalEventSubscriptions(String signalName, String tenantId) {
        EventSubscriptionManager eventSubscriptionManager = Context.getCommandContext().getEventSubscriptionManager();
        if (tenantId != null) {
            return eventSubscriptionManager.findSignalEventSubscriptionsByEventNameAndTenantIdIncludeWithoutTenantId(signalName, tenantId);
        }
        return eventSubscriptionManager.findSignalEventSubscriptionsByEventNameAndTenantId(signalName, null);
    }

    protected boolean isActiveEventSubscription(SignalEventSubscriptionEntity signalEventSubscriptionEntity) {
        return this.isStartEventSubscription(signalEventSubscriptionEntity) || this.isActiveIntermediateEventSubscription(signalEventSubscriptionEntity);
    }

    protected boolean isStartEventSubscription(SignalEventSubscriptionEntity signalEventSubscriptionEntity) {
        return signalEventSubscriptionEntity.getExecutionId() == null;
    }

    protected boolean isActiveIntermediateEventSubscription(SignalEventSubscriptionEntity signalEventSubscriptionEntity) {
        ExecutionEntity execution = signalEventSubscriptionEntity.getExecution();
        return execution != null && !execution.isEnded() && !execution.isCanceled();
    }
}

