/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.ModificationObserverBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityStartBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ActivityInstanceState;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.InstantiationStack;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.FoxAtomicOperationDeleteCascadeFireActivityEnd;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.camunda.bpm.engine.impl.tree.ExecutionWalker;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.ScopeCollector;
import org.camunda.bpm.engine.impl.tree.ScopeExecutionCollector;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class PvmExecutionImpl
extends CoreExecution
implements ActivityExecution,
PvmProcessInstance {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(PvmExecutionImpl.class.getName());
    protected transient ProcessDefinitionImpl processDefinition;
    protected transient ExecutionStartContext startContext;
    protected transient ActivityImpl activity;
    protected transient PvmActivity nextActivity;
    protected transient TransitionImpl transition;
    protected transient List<PvmTransition> transitionsToTake = null;
    protected String activityInstanceId;
    protected String caseInstanceId;
    protected boolean deleteRoot;
    protected String deleteReason;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent = false;
    protected boolean isEnded = false;
    protected boolean isEventScope = false;
    protected boolean preserveScope = false;
    protected int activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    protected long sequenceCounter = 0L;

    @Override
    public PvmExecutionImpl createExecution() {
        return this.createExecution(false);
    }

    @Override
    public abstract PvmExecutionImpl createExecution(boolean var1);

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        PvmExecutionImpl processInstance = this.getProcessInstance();
        String caseInstanceId = null;
        if (processInstance != null) {
            caseInstanceId = processInstance.getCaseInstanceId();
        }
        return this.createSubProcessInstance(processDefinition, businessKey, caseInstanceId);
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey, String caseInstanceId) {
        PvmExecutionImpl subProcessInstance = this.newExecution();
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.setProcessInstance(subProcessInstance);
        subProcessInstance.setActivity(processDefinition.getInitial());
        if (businessKey != null) {
            subProcessInstance.setBusinessKey(businessKey);
        }
        if (caseInstanceId != null) {
            subProcessInstance.setCaseInstanceId(caseInstanceId);
        }
        return subProcessInstance;
    }

    protected abstract PvmExecutionImpl newExecution();

    @Override
    public abstract CmmnExecution createSubCaseInstance(CmmnCaseDefinition var1);

    @Override
    public abstract CmmnExecution createSubCaseInstance(CmmnCaseDefinition var1, String var2);

    public abstract void initialize();

    public abstract void initializeTimerDeclarations();

    public void executeIoMapping() {
        ActivityImpl currentActivity;
        ScopeImpl currentScope = this.getScopeActivity();
        if (currentScope != currentScope.getProcessDefinition() && (currentActivity = (ActivityImpl)currentScope) != null && currentActivity.getIoMapping() != null && !this.skipIoMapping) {
            currentActivity.getIoMapping().executeInputParameters(this);
        }
    }

    @Override
    public void start() {
        this.start(null);
    }

    @Override
    public void start(Map<String, Object> variables) {
        this.startContext = new ProcessInstanceStartContext(this.getActivity());
        this.initialize();
        this.initializeTimerDeclarations();
        if (variables != null) {
            this.setVariables(variables);
        }
        this.fireHistoricProcessStartEvent();
        this.performOperation(PvmAtomicOperation.PROCESS_START);
    }

    public void startWithoutExecuting() {
        this.initialize();
        this.initializeTimerDeclarations();
        this.fireHistoricProcessStartEvent();
        this.performOperation(PvmAtomicOperation.FIRE_PROCESS_START);
    }

    public abstract void fireHistoricProcessStartEvent();

    @Override
    public void destroy() {
        log.fine("destroying " + this);
        this.setScope(false);
    }

    protected void removeEventScopes() {
        ArrayList<? extends PvmExecutionImpl> childExecutions = new ArrayList<PvmExecutionImpl>(this.getEventScopeExecutions());
        for (PvmExecutionImpl pvmExecutionImpl : childExecutions) {
            log.fine("removing eventScope " + pvmExecutionImpl);
            pvmExecutionImpl.destroy();
            pvmExecutionImpl.remove();
        }
    }

    public void clearScope(String reason, boolean skipCustomListeners, boolean skipIoMappings) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        if (this.getSubProcessInstance() != null) {
            this.getSubProcessInstance().deleteCascade(reason, skipCustomListeners, skipIoMappings);
        }
        ArrayList<? extends PvmExecutionImpl> executions = new ArrayList<PvmExecutionImpl>(this.getNonEventScopeExecutions());
        for (PvmExecutionImpl pvmExecutionImpl : executions) {
            if (pvmExecutionImpl.getSubProcessInstance() != null) {
                pvmExecutionImpl.getSubProcessInstance().deleteCascade(reason, skipCustomListeners, skipIoMappings);
            }
            pvmExecutionImpl.deleteCascade(reason, skipCustomListeners, skipIoMappings);
        }
        ActivityImpl activity = this.getActivity();
        if (this.isActive && activity != null) {
            this.setCanceled(true);
            this.performOperation(PvmAtomicOperation.FIRE_ACTIVITY_END);
            this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
        }
    }

    @Override
    public void interrupt(String reason) {
        this.interrupt(reason, false, false);
    }

    public void interrupt(String reason, boolean skipCustomListeners, boolean skipIoMappings) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Interrupting execution " + this);
        }
        this.clearScope(reason, skipCustomListeners, skipIoMappings);
    }

    @Override
    public void end(boolean completeScope) {
        this.setCompleteScope(completeScope);
        this.isActive = false;
        this.isEnded = true;
        this.performOperation(PvmAtomicOperation.ACTIVITY_NOTIFY_LISTENER_END);
    }

    @Override
    public void endCompensation() {
        this.remove();
        this.performOperation(PvmAtomicOperation.FIRE_ACTIVITY_END);
        this.getParent().signal("compensationDone", null);
    }

    public void propagateEnd() {
        if (!this.isEnded()) {
            throw new ProcessEngineException(this.toString() + " must have ended before ending can be propagated");
        }
        if (this.isProcessInstanceExecution()) {
            this.performOperation(PvmAtomicOperation.PROCESS_END);
        }
    }

    @Override
    public void remove() {
        PvmExecutionImpl parent = this.getParent();
        if (parent != null) {
            parent.getExecutions().remove(this);
            long parentSequenceCounter = parent.getSequenceCounter();
            long mySequenceCounter = this.getSequenceCounter();
            if (mySequenceCounter > parentSequenceCounter) {
                parent.setSequenceCounter(mySequenceCounter);
            }
            parent.skipCustomListeners |= this.skipCustomListeners;
            parent.skipIoMapping |= this.skipIoMapping;
        }
        this.isActive = false;
        this.isEnded = true;
        this.removeEventScopes();
    }

    public PvmExecutionImpl createConcurrentExecution() {
        if (!this.isScope()) {
            throw new ProcessEngineException("Cannot create concurrent execution for " + this);
        }
        List<? extends PvmExecutionImpl> children = this.getNonEventScopeExecutions();
        if (children.isEmpty()) {
            PvmExecutionImpl replacingExecution = this.createExecution();
            replacingExecution.setConcurrent(true);
            replacingExecution.setScope(false);
            replacingExecution.replace(this);
            this.inactivate();
            this.setActivity(null);
        } else if (children.size() == 1) {
            PvmExecutionImpl child = children.get(0);
            PvmExecutionImpl concurrentReplacingExecution = this.createExecution();
            concurrentReplacingExecution.setConcurrent(true);
            concurrentReplacingExecution.setScope(false);
            child.setParent(concurrentReplacingExecution);
            concurrentReplacingExecution.getExecutions().add(child);
            this.getExecutions().remove(child);
            this.leaveActivityInstance();
            this.setActivity(null);
        }
        PvmExecutionImpl concurrentExecution = this.createExecution();
        concurrentExecution.setConcurrent(true);
        concurrentExecution.setScope(false);
        return concurrentExecution;
    }

    @Override
    public boolean tryPruneLastConcurrentChild() {
        PvmExecutionImpl lastConcurrent;
        if (this.getNonEventScopeExecutions().size() == 1 && (lastConcurrent = this.getNonEventScopeExecutions().get(0)).isConcurrent()) {
            if (!lastConcurrent.isScope()) {
                this.setActivity(lastConcurrent.getActivity());
                this.setTransition(lastConcurrent.getTransition());
                lastConcurrent.setReplacedBy(this);
                if (lastConcurrent.getExecutions().size() > 0) {
                    this.getExecutions().clear();
                    for (PvmExecutionImpl pvmExecutionImpl : lastConcurrent.getExecutions()) {
                        this.getExecutions().add(pvmExecutionImpl);
                        pvmExecutionImpl.setParent(this);
                    }
                    lastConcurrent.getExecutions().clear();
                }
                this.setVariablesLocal(lastConcurrent.getVariablesLocal());
                if (!this.isActive() && lastConcurrent.isActive()) {
                    this.setActive(true);
                }
                lastConcurrent.remove();
            } else {
                LegacyBehavior.pruneConcurrentScope(lastConcurrent);
            }
            return true;
        }
        return false;
    }

    @Override
    public void deleteCascade(String deleteReason) {
        this.deleteCascade(deleteReason, false);
    }

    public void deleteCascade(String deleteReason, boolean skipCustomListeners) {
        this.deleteCascade(deleteReason, skipCustomListeners, false);
    }

    public void deleteCascade(String deleteReason, boolean skipCustomListeners, boolean skipIoMappings) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.isEnded = true;
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        this.performOperation(PvmAtomicOperation.DELETE_CASCADE);
    }

    public void deleteCascade2(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(new FoxAtomicOperationDeleteCascadeFireActivityEnd());
    }

    public void executeEventHandlerActivity(ActivityImpl eventHandlerActivity) {
        ScopeImpl flowScope = eventHandlerActivity.getFlowScope();
        ScopeImpl eventScope = eventHandlerActivity.getEventScope();
        if (eventHandlerActivity.getActivityStartBehavior() == ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE && flowScope != eventScope) {
            this.findExecutionForScope(eventScope, flowScope).executeActivity(eventHandlerActivity);
        } else {
            this.executeActivity(eventHandlerActivity);
        }
    }

    public abstract PvmExecutionImpl getReplacedBy();

    public void setReplacedBy(PvmExecutionImpl replacedBy) {
        replacedBy.setActivityInstanceId(this.activityInstanceId);
    }

    public void replace(PvmExecutionImpl execution) {
        this.activityInstanceId = execution.getActivityInstanceId();
        this.isActive = execution.isActive;
        execution.leaveActivityInstance();
    }

    @Override
    public void signal(String signalName, Object signalData) {
        if (this.getActivity() == null) {
            throw new PvmException("cannot signal execution " + this.id + ": it has no current activity");
        }
        SignallableActivityBehavior activityBehavior = (SignallableActivityBehavior)this.activity.getActivityBehavior();
        try {
            activityBehavior.signal(this, signalName, signalData);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't process signal '" + signalName + "' on activity '" + this.activity.getId() + "': " + e.getMessage(), e);
        }
    }

    public void take() {
        if (this.transition == null) {
            throw new PvmException(this.toString() + ": no transition to take specified");
        }
        if (this.transition == null) {
            throw new PvmException("transition is null");
        }
        TransitionImpl transitionImpl = this.transition;
        this.setActivity(transitionImpl.getSource());
        this.setActivityInstanceId(null);
        this.setActive(true);
        this.performOperation(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE);
    }

    @Override
    public void executeActivity(PvmActivity activity) {
        if (!activity.getIncomingTransitions().isEmpty()) {
            throw new ProcessEngineException("Activity is contained in normal flow and cannot be executed using executeActivity().");
        }
        ActivityStartBehavior activityStartBehavior = activity.getActivityStartBehavior();
        if (!this.isScope() && ActivityStartBehavior.DEFAULT != activityStartBehavior) {
            throw new ProcessEngineException("Activity '" + activity + "' with start behavior '" + (Object)((Object)activityStartBehavior) + "'" + "cannot be executed by non-scope execution.");
        }
        PvmActivity activityImpl = activity;
        this.setActive(true);
        switch (activityStartBehavior) {
            case CONCURRENT_IN_FLOW_SCOPE: {
                this.nextActivity = activityImpl;
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_CONCURRENT);
                break;
            }
            case CANCEL_EVENT_SCOPE: {
                this.nextActivity = activityImpl;
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_CANCEL_SCOPE);
                break;
            }
            case INTERRUPT_EVENT_SCOPE: {
                this.nextActivity = activityImpl;
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_INTERRUPT_SCOPE);
                break;
            }
            default: {
                this.setActivity(activityImpl);
                this.performOperation(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE);
            }
        }
    }

    public void executeActivitiesConcurrent(List<PvmActivity> activityStack, PvmActivity targetActivity, PvmTransition targetTransition, Map<String, Object> variables, Map<String, Object> localVariables, boolean skipCustomListeners, boolean skipIoMappings) {
        PvmExecutionImpl propagatingExecution = this.createConcurrentExecution();
        ScopeImpl flowScope = null;
        if (!activityStack.isEmpty()) {
            flowScope = activityStack.get(0).getFlowScope();
        } else if (targetActivity != null) {
            flowScope = targetActivity.getFlowScope();
        } else if (targetTransition != null) {
            flowScope = targetTransition.getSource().getFlowScope();
        }
        if (flowScope.getActivityBehavior() instanceof ModificationObserverBehavior) {
            ModificationObserverBehavior flowScopeBehavior = (ModificationObserverBehavior)flowScope.getActivityBehavior();
            flowScopeBehavior.concurrentExecutionCreated(propagatingExecution.getParent(), propagatingExecution);
        }
        propagatingExecution.executeActivities(activityStack, targetActivity, targetTransition, variables, localVariables, skipCustomListeners, skipIoMappings);
    }

    public void executeActivities(List<PvmActivity> activityStack, PvmActivity targetActivity, PvmTransition targetTransition, Map<String, Object> variables, Map<String, Object> localVariables, boolean skipCustomListeners, boolean skipIoMappings) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMapping = skipIoMappings;
        this.activityInstanceId = null;
        this.isEnded = false;
        if (!activityStack.isEmpty()) {
            ExecutionStartContext executionStartContext = new ExecutionStartContext(false);
            InstantiationStack instantiationStack = new InstantiationStack(activityStack, targetActivity, targetTransition);
            executionStartContext.setInstantiationStack(instantiationStack);
            executionStartContext.setVariables(variables);
            executionStartContext.setVariablesLocal(localVariables);
            this.setStartContext(executionStartContext);
            this.performOperation(PvmAtomicOperation.ACTIVITY_INIT_STACK);
        } else if (targetActivity != null) {
            this.setVariables(variables);
            this.setVariablesLocal(localVariables);
            this.setActivity(targetActivity);
            this.performOperation(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE);
        } else if (targetTransition != null) {
            this.setVariables(variables);
            this.setVariablesLocal(localVariables);
            this.setActivity(targetTransition.getSource());
            this.setTransition((TransitionImpl)targetTransition);
            this.performOperation(PvmAtomicOperation.TRANSITION_START_NOTIFY_LISTENER_TAKE);
        }
    }

    @Override
    public List<ActivityExecution> findInactiveConcurrentExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        ArrayList<PvmExecutionImpl> otherConcurrentExecutions = new ArrayList<PvmExecutionImpl>();
        if (this.isConcurrent()) {
            List<PvmExecutionImpl> concurrentExecutions = this.getParent().getAllChildExecutions();
            for (PvmExecutionImpl concurrentExecution : concurrentExecutions) {
                if (concurrentExecution.getActivity() == activity) {
                    if (concurrentExecution.isActive()) continue;
                    inactiveConcurrentExecutionsInActivity.add(concurrentExecution);
                    continue;
                }
                otherConcurrentExecutions.add(concurrentExecution);
            }
        } else if (!this.isActive()) {
            inactiveConcurrentExecutionsInActivity.add(this);
        } else {
            otherConcurrentExecutions.add(this);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("inactive concurrent executions in '" + activity + "': " + inactiveConcurrentExecutionsInActivity);
            log.fine("other concurrent executions: " + otherConcurrentExecutions);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    protected List<PvmExecutionImpl> getAllChildExecutions() {
        ArrayList<PvmExecutionImpl> childExecutions = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            childExecutions.add(pvmExecutionImpl);
            childExecutions.addAll(pvmExecutionImpl.getAllChildExecutions());
        }
        return childExecutions;
    }

    @Override
    public void leaveActivityViaTransition(PvmTransition outgoingTransition) {
        this.leaveActivityViaTransitions(Arrays.asList(outgoingTransition), Collections.emptyList());
    }

    @Override
    public void leaveActivityViaTransitions(List<PvmTransition> _transitions, List<? extends ActivityExecution> _recyclableExecutions) {
        List<ActivityExecution> recyclableExecutions = Collections.emptyList();
        if (_recyclableExecutions != null) {
            recyclableExecutions = new ArrayList<ActivityExecution>(_recyclableExecutions);
        }
        recyclableExecutions.remove(this);
        for (ActivityExecution execution : recyclableExecutions) {
            execution.end(_transitions.isEmpty());
        }
        PvmExecutionImpl propagatingExecution = this;
        if (this.getReplacedBy() != null) {
            propagatingExecution = this.getReplacedBy();
        }
        if (_transitions.isEmpty()) {
            propagatingExecution.end(!propagatingExecution.isConcurrent());
        } else {
            propagatingExecution.setTransitionsToTake(_transitions);
            propagatingExecution.performOperation(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_END);
        }
    }

    protected boolean hasConcurrentSiblings(PvmExecutionImpl concurrentRoot) {
        if (concurrentRoot.isProcessInstanceExecution()) {
            return false;
        }
        List<? extends PvmExecutionImpl> executions = concurrentRoot.getParent().getExecutions();
        for (PvmExecutionImpl pvmExecutionImpl : executions) {
            if (pvmExecutionImpl == concurrentRoot || pvmExecutionImpl.isEventScope()) continue;
            return true;
        }
        return false;
    }

    protected boolean allExecutionsInSameActivity(List<PvmExecutionImpl> executions) {
        if (executions.size() > 1) {
            String activityId = executions.get(0).getActivityId();
            for (PvmExecutionImpl execution : executions) {
                String otherActivityId = execution.getActivityId();
                if (execution.isEnded || !(activityId == null && otherActivityId != null || activityId != null && otherActivityId == null) && (activityId == null || otherActivityId == null || otherActivityId.equals(activityId))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    public abstract List<? extends PvmExecutionImpl> getExecutions();

    public List<? extends PvmExecutionImpl> getNonEventScopeExecutions() {
        List<? extends PvmExecutionImpl> children = this.getExecutions();
        ArrayList<PvmExecutionImpl> result = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : children) {
            if (pvmExecutionImpl.isEventScope()) continue;
            result.add(pvmExecutionImpl);
        }
        return result;
    }

    public List<? extends PvmExecutionImpl> getEventScopeExecutions() {
        List<? extends PvmExecutionImpl> children = this.getExecutions();
        ArrayList<PvmExecutionImpl> result = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : children) {
            if (!pvmExecutionImpl.isEventScope()) continue;
            result.add(pvmExecutionImpl);
        }
        return result;
    }

    @Override
    public PvmExecutionImpl findExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            PvmExecutionImpl result = pvmExecutionImpl.findExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<PvmExecution> findExecutions(String activityId) {
        ArrayList<PvmExecution> matchingExecutions = new ArrayList<PvmExecution>();
        this.collectExecutions(activityId, matchingExecutions);
        return matchingExecutions;
    }

    protected void collectExecutions(String activityId, List<PvmExecution> executions) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            executions.add(this);
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            pvmExecutionImpl.collectExecutions(activityId, executions);
        }
    }

    @Override
    public List<String> findActiveActivityIds() {
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        this.collectActiveActivityIds(activeActivityIds);
        return activeActivityIds;
    }

    protected void collectActiveActivityIds(List<String> activeActivityIds) {
        ActivityImpl activity = this.getActivity();
        if (this.isActive && activity != null) {
            activeActivityIds.add(activity.getId());
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            pvmExecutionImpl.collectActiveActivityIds(activeActivityIds);
        }
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
    }

    public ProcessDefinitionImpl getProcessDefinition() {
        return this.processDefinition;
    }

    @Override
    public abstract PvmExecutionImpl getProcessInstance();

    public abstract void setProcessInstance(PvmExecutionImpl var1);

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @Override
    public ActivityImpl getActivity() {
        return this.activity;
    }

    public String getActivityId() {
        ActivityImpl activity = this.getActivity();
        if (activity != null) {
            return activity.getId();
        }
        return null;
    }

    @Override
    public String getCurrentActivityName() {
        ActivityImpl activity = this.getActivity();
        if (activity != null) {
            return activity.getName();
        }
        return null;
    }

    @Override
    public String getCurrentActivityId() {
        return this.getActivityId();
    }

    @Override
    public void setActivity(PvmActivity activity) {
        this.activity = (ActivityImpl)activity;
    }

    @Override
    public void enterActivityInstance() {
        ActivityImpl activity = this.getActivity();
        this.activityInstanceId = this.generateActivityInstanceId(activity.getId());
        if (log.isLoggable(Level.FINE)) {
            log.fine("[ENTER] " + this + ": " + this.activityInstanceId + ", parent: " + this.getParentActivityInstanceId());
        }
        this.executeIoMapping();
        if (activity.isScope()) {
            this.initializeTimerDeclarations();
        }
    }

    protected abstract String generateActivityInstanceId(String var1);

    @Override
    public void leaveActivityInstance() {
        if (this.activityInstanceId != null && log.isLoggable(Level.FINE)) {
            log.fine("[LEAVE] " + this + ": " + this.activityInstanceId);
        }
        this.activityInstanceId = this.getParentActivityInstanceId();
        this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    }

    @Override
    public String getParentActivityInstanceId() {
        if (this.isProcessInstanceExecution()) {
            return this.getId();
        }
        PvmExecutionImpl parent = this.getParent();
        if (parent.isCompensationThrowing()) {
            return parent.getParentActivityInstanceId();
        }
        return parent.getActivityInstanceId();
    }

    public void forceUpdateActivityInstance() {
        this.activityInstanceId = this.generateActivityInstanceId(this.getActivity().getId());
    }

    @Override
    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    @Override
    public abstract PvmExecutionImpl getParent();

    @Override
    public String getParentId() {
        PvmExecutionImpl parent = this.getParent();
        if (parent != null) {
            return parent.getId();
        }
        return null;
    }

    public abstract void setParent(PvmExecutionImpl var1);

    @Override
    public abstract PvmExecutionImpl getSuperExecution();

    public abstract void setSuperExecution(PvmExecutionImpl var1);

    public abstract PvmExecutionImpl getSubProcessInstance();

    public abstract void setSubProcessInstance(PvmExecutionImpl var1);

    public abstract CmmnExecution getSuperCaseExecution();

    public abstract void setSuperCaseExecution(CmmnExecution var1);

    public abstract CmmnExecution getSubCaseInstance();

    public abstract void setSubCaseInstance(CmmnExecution var1);

    protected ScopeImpl getScopeActivity() {
        ScopeImpl scope = null;
        scope = this.isProcessInstanceExecution() ? this.getProcessDefinition() : this.getActivity();
        return scope;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public PvmExecutionImpl findExecutionForFlowScope(PvmScope targetFlowScope) {
        PvmExecutionImpl scopeExecution = this.isScope() ? this : this.getParent();
        ActivityImpl currentActivity = this.getActivity();
        EnsureUtil.ensureNotNull("activity of current execution", (Object)currentActivity);
        currentActivity = currentActivity.isScope() ? currentActivity : currentActivity.getFlowScope();
        return scopeExecution.findExecutionForScope(currentActivity, (ScopeImpl)targetFlowScope);
    }

    public PvmExecutionImpl findExecutionForScope(ScopeImpl currentScope, ScopeImpl targetScope) {
        if (!targetScope.isScope()) {
            throw new ProcessEngineException("Target scope must be a scope.");
        }
        Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = this.createActivityExecutionMapping(currentScope);
        PvmExecutionImpl scopeExecution = activityExecutionMapping.get(targetScope);
        if (scopeExecution == null) {
            scopeExecution = LegacyBehavior.getScopeExecution(targetScope, activityExecutionMapping);
        }
        return scopeExecution;
    }

    @Override
    public Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping() {
        ScopeImpl currentActivity = this.getActivity();
        EnsureUtil.ensureNotNull("activity of current execution", (Object)currentActivity);
        if (!currentActivity.isScope() || this.activityInstanceId == null || currentActivity.isScope() && !this.isScope()) {
            currentActivity = currentActivity.getFlowScope();
        }
        PvmExecutionImpl scopeExecution = this.getFlowScopeExecution();
        return scopeExecution.createActivityExecutionMapping(currentActivity);
    }

    protected PvmExecutionImpl getFlowScopeExecution() {
        ActivityImpl currentActivity = this.getActivity();
        if (!this.isScope || currentActivity != null && this.isCompensationHandler(currentActivity) && !currentActivity.isScope()) {
            return this.getParent().getFlowScopeExecution();
        }
        return this;
    }

    protected boolean isCompensationHandler(ScopeImpl activity) {
        Boolean isForCompensation = (Boolean)activity.getProperty("isForCompensation");
        return isForCompensation != null && isForCompensation != false;
    }

    public boolean isCompensationThrowing() {
        Boolean isCompensationThrowing;
        ActivityImpl currentActivity = this.getActivity();
        return currentActivity != null && (isCompensationThrowing = (Boolean)currentActivity.getProperty("throwsCompensation")) != null && isCompensationThrowing != false;
    }

    public Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping(ScopeImpl currentScope) {
        if (!this.isScope()) {
            throw new ProcessEngineException("Execution must be a scope execution");
        }
        if (!currentScope.isScope()) {
            throw new ProcessEngineException("Current scope must be a scope.");
        }
        ScopeExecutionCollector scopeExecutionCollector = new ScopeExecutionCollector();
        new ExecutionWalker(this).addPreCollector(scopeExecutionCollector).walkUntil();
        List<PvmExecutionImpl> scopeExecutions = scopeExecutionCollector.getExecutions();
        ScopeCollector scopeCollector = new ScopeCollector();
        new FlowScopeWalker(currentScope).addPreCollector(scopeCollector).walkUntil();
        List<ScopeImpl> scopes = scopeCollector.getScopes();
        if (scopes.size() == scopeExecutions.size()) {
            HashMap<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = new HashMap<ScopeImpl, PvmExecutionImpl>();
            for (int i = 0; i < scopes.size(); ++i) {
                activityExecutionMapping.put(scopes.get(i), scopeExecutions.get(i));
            }
            return activityExecutionMapping;
        }
        return LegacyBehavior.createActivityExecutionMapping(scopeExecutions, scopes);
    }

    public String toString() {
        if (this.isProcessInstanceExecution()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isConcurrent ? "Concurrent" : "") + (this.isScope ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }

    @Override
    public String getVariableScopeKey() {
        return "execution";
    }

    @Override
    public AbstractVariableScope getParentVariableScope() {
        return this.getParent();
    }

    public long getSequenceCounter() {
        return this.sequenceCounter;
    }

    public void setSequenceCounter(long sequenceCounter) {
        this.sequenceCounter = sequenceCounter;
    }

    public void incrementSequenceCounter() {
        ++this.sequenceCounter;
    }

    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    public boolean isDeleteRoot() {
        return this.deleteRoot;
    }

    @Override
    public TransitionImpl getTransition() {
        return this.transition;
    }

    public List<PvmTransition> getTransitionsToTake() {
        return this.transitionsToTake;
    }

    public void setTransitionsToTake(List<PvmTransition> transitionsToTake) {
        this.transitionsToTake = transitionsToTake;
    }

    @Override
    public String getCurrentTransitionId() {
        TransitionImpl transition = this.getTransition();
        if (transition != null) {
            return transition.getId();
        }
        return null;
    }

    public void setTransition(PvmTransition transition) {
        this.transition = (TransitionImpl)transition;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public boolean isCanceled() {
        return ActivityInstanceState.CANCELED.getStateCode() == this.activityInstanceState;
    }

    public void setCanceled(boolean canceled) {
        if (canceled) {
            this.activityInstanceState = ActivityInstanceState.CANCELED.getStateCode();
        }
    }

    @Override
    public boolean isCompleteScope() {
        return ActivityInstanceState.SCOPE_COMPLETE.getStateCode() == this.activityInstanceState;
    }

    public void setCompleteScope(boolean completeScope) {
        if (completeScope) {
            this.activityInstanceState = ActivityInstanceState.SCOPE_COMPLETE.getStateCode();
        }
    }

    public void setPreserveScope(boolean preserveScope) {
        this.preserveScope = preserveScope;
    }

    public boolean isPreserveScope() {
        return this.preserveScope;
    }

    public int getActivityInstanceState() {
        return this.activityInstanceState;
    }

    public boolean isEventScope() {
        return this.isEventScope;
    }

    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    public ExecutionStartContext getExecutionStartContext() {
        return this.startContext;
    }

    public void disposeProcessInstanceStartContext() {
        this.startContext = null;
    }

    public void disposeExecutionStartContext() {
        this.startContext = null;
    }

    @Override
    public PvmActivity getNextActivity() {
        return this.nextActivity;
    }

    @Override
    public boolean isProcessInstanceExecution() {
        return this.getParent() == null;
    }

    public ProcessInstanceStartContext getProcessInstanceStartContext() {
        if (this.startContext != null && this.startContext instanceof ProcessInstanceStartContext) {
            return (ProcessInstanceStartContext)this.startContext;
        }
        return null;
    }

    public boolean hasProcessInstanceStartContext() {
        return this.startContext != null && this.startContext instanceof ProcessInstanceStartContext;
    }

    public void setStartContext(ExecutionStartContext startContext) {
        this.startContext = startContext;
    }

    public void setNextActivity(PvmActivity nextActivity) {
        this.nextActivity = nextActivity;
    }

    public PvmExecutionImpl getParentScopeExecution(boolean considerSuperExecution) {
        if (this.isProcessInstanceExecution()) {
            if (considerSuperExecution && this.getSuperExecution() != null) {
                PvmExecutionImpl superExecution = this.getSuperExecution();
                if (superExecution.isScope()) {
                    return superExecution;
                }
                return superExecution.getParent();
            }
            return null;
        }
        PvmExecutionImpl parent = this.getParent();
        if (parent.isScope()) {
            return parent;
        }
        return parent.getParent();
    }
}

