/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContextFactory;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CommandInvocationContext;

public class CommandContextInterceptor
extends CommandInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CommandContextInterceptor.class.getName());
    protected CommandContextFactory commandContextFactory;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected boolean alwaysOpenNew;

    public CommandContextInterceptor() {
    }

    public CommandContextInterceptor(CommandContextFactory commandContextFactory, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.commandContextFactory = commandContextFactory;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public CommandContextInterceptor(CommandContextFactory commandContextFactory, ProcessEngineConfigurationImpl processEngineConfiguration, boolean alwaysOpenNew) {
        this(commandContextFactory, processEngineConfiguration);
        this.alwaysOpenNew = alwaysOpenNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        CommandContext context = Context.getCommandContext();
        boolean openNew = this.alwaysOpenNew || context == null;
        CommandInvocationContext commandInvocationContext = new CommandInvocationContext(command);
        Context.setCommandInvocationContext(commandInvocationContext);
        try {
            if (openNew) {
                LOGGER.log(Level.FINE, "Opening new command context.");
                context = this.commandContextFactory.createCommandContext();
            } else {
                LOGGER.log(Level.FINE, "Reusing existing command context.");
            }
            Context.setCommandContext(context);
            Context.setProcessEngineConfiguration(this.processEngineConfiguration);
            T t = this.next.execute(command);
            return t;
        }
        catch (Exception e) {
            commandInvocationContext.trySetThrowable(e);
        }
        finally {
            try {
                if (openNew) {
                    LOGGER.log(Level.FINE, "Closing command context.");
                    context.close(commandInvocationContext);
                } else {
                    commandInvocationContext.rethrow();
                }
            }
            finally {
                Context.removeCommandInvocationContext();
                Context.removeCommandContext();
                Context.removeProcessEngineConfiguration();
            }
        }
        return null;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public void setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineContext(ProcessEngineConfigurationImpl processEngineContext) {
        this.processEngineConfiguration = processEngineContext;
    }
}

