/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SignalEventReceivedCmd
implements Command<Void> {
    protected final String eventName;
    protected final String executionId;
    protected final Map<String, Object> variables;

    public SignalEventReceivedCmd(String eventName, String executionId, Map<String, Object> variables) {
        this.eventName = eventName;
        this.executionId = executionId;
        this.variables = variables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EventSubscriptionManager eventSubscriptionManager = commandContext.getEventSubscriptionManager();
        List<SignalEventSubscriptionEntity> signalEvents = null;
        if (this.executionId == null) {
            signalEvents = eventSubscriptionManager.findSignalEventSubscriptionsByEventName(this.eventName);
        } else {
            ExecutionManager executionManager = commandContext.getExecutionManager();
            ExecutionEntity execution = executionManager.findExecutionById(this.executionId);
            EnsureUtil.ensureNotNull("Cannot find execution with id '" + this.executionId + "'", "execution", (Object)execution);
            signalEvents = eventSubscriptionManager.findSignalEventSubscriptionsByNameAndExecution(this.eventName, this.executionId);
            EnsureUtil.ensureNotEmpty("Execution '" + this.executionId + "' has not subscribed to a signal event with name '" + this.eventName + "'.", signalEvents);
        }
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        for (SignalEventSubscriptionEntity event : signalEvents) {
            String processInstanceId = event.getProcessInstanceId();
            authorizationManager.checkUpdateProcessInstanceById(processInstanceId);
        }
        HashMap<String, Object> payload = null;
        if (this.variables != null) {
            payload = new HashMap<String, Object>(this.variables);
        }
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : signalEvents) {
            signalEventSubscriptionEntity.eventReceived(payload, false);
        }
        return null;
    }
}

