/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ActivityInstanceImpl;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TransitionInstanceImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class GetActivityInstanceCmd
implements Command<ActivityInstance> {
    protected String processInstanceId;

    public GetActivityInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public ActivityInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)this.processInstanceId);
        List<ExecutionEntity> executionList = this.loadProcessInstance(this.processInstanceId, commandContext);
        if (executionList.isEmpty()) {
            return null;
        }
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkReadProcessInstance(this.processInstanceId);
        List<ExecutionEntity> nonEventScopeExecutions = this.filterNonEventScopeExecutions(executionList);
        List<ExecutionEntity> leaves = this.filterLeaves(nonEventScopeExecutions);
        ExecutionEntity processInstance = this.filterProcessInstance(executionList);
        ActivityInstanceImpl processActInst = this.createActivityInstance(processInstance, processInstance.getProcessDefinition(), this.processInstanceId, null);
        HashMap<String, ActivityInstanceImpl> activityInstances = new HashMap<String, ActivityInstanceImpl>();
        activityInstances.put(this.processInstanceId, processActInst);
        HashMap<String, TransitionInstanceImpl> transitionInstances = new HashMap<String, TransitionInstanceImpl>();
        for (ExecutionEntity leaf : leaves) {
            if (leaf.getActivity() == null) continue;
            if (leaf.getActivityInstanceId() != null) {
                ActivityInstanceImpl leafInstance = this.createActivityInstance(leaf, leaf.getActivity(), leaf.getActivityInstanceId(), leaf.getParentActivityInstanceId());
                activityInstances.put(leafInstance.getId(), leafInstance);
            } else {
                TransitionInstanceImpl transitionInstance = this.createTransitionInstance(leaf);
                transitionInstances.put(transitionInstance.getId(), transitionInstance);
            }
            Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = leaf.createActivityExecutionMapping();
            activityExecutionMapping.remove(leaf.getActivity());
            activityExecutionMapping.remove(leaf.getProcessDefinition());
            LegacyBehavior.removeLegacyNonScopesFromMapping(activityExecutionMapping);
            for (Map.Entry<ScopeImpl, PvmExecutionImpl> scopeExecutionEntry : activityExecutionMapping.entrySet()) {
                ScopeImpl scope = scopeExecutionEntry.getKey();
                PvmExecutionImpl scopeExecution = scopeExecutionEntry.getValue();
                String activityInstanceId = null;
                activityInstanceId = scopeExecution.getParent() != null && scopeExecution.getParent().isCompensationThrowing() ? scopeExecution.getActivityInstanceId() : scopeExecution.getParentActivityInstanceId();
                if (activityInstances.containsKey(activityInstanceId)) continue;
                String parentActivityInstanceId = null;
                PvmExecutionImpl parent = scopeExecution.getParent();
                if (parent != null) {
                    parentActivityInstanceId = parent.getParentActivityInstanceId();
                }
                ActivityInstanceImpl scopeInstance = this.createActivityInstance(scopeExecution, scope, activityInstanceId, parentActivityInstanceId);
                activityInstances.put(activityInstanceId, scopeInstance);
            }
        }
        LegacyBehavior.repairParentRelationships(activityInstances.values(), this.processInstanceId);
        this.populateChildInstances(activityInstances, transitionInstances);
        return processActInst;
    }

    protected ActivityInstanceImpl createActivityInstance(PvmExecutionImpl scopeExecution, ScopeImpl scope, String activityInstanceId, String parentActivityInstanceId) {
        ActivityInstanceImpl actInst = new ActivityInstanceImpl();
        actInst.setId(activityInstanceId);
        actInst.setParentActivityInstanceId(parentActivityInstanceId);
        actInst.setProcessInstanceId(scopeExecution.getProcessInstanceId());
        actInst.setProcessDefinitionId(scopeExecution.getProcessDefinitionId());
        actInst.setBusinessKey(scopeExecution.getBusinessKey());
        actInst.setActivityId(scope.getId());
        String name = scope.getName();
        if (name == null) {
            name = (String)scope.getProperty("name");
        }
        actInst.setActivityName(name);
        if (scope.getId().equals(scopeExecution.getProcessDefinition().getId())) {
            actInst.setActivityType("processDefinition");
        } else {
            actInst.setActivityType((String)scope.getProperty("type"));
        }
        ArrayList<String> executionIds = new ArrayList<String>();
        executionIds.add(scopeExecution.getId());
        for (PvmExecutionImpl pvmExecutionImpl : scopeExecution.getNonEventScopeExecutions()) {
            if (!pvmExecutionImpl.isConcurrent() || pvmExecutionImpl.getActivityId() != null && pvmExecutionImpl.isActive()) continue;
            executionIds.add(pvmExecutionImpl.getId());
        }
        actInst.setExecutionIds(executionIds.toArray(new String[executionIds.size()]));
        return actInst;
    }

    protected TransitionInstanceImpl createTransitionInstance(PvmExecutionImpl execution) {
        TransitionInstanceImpl transitionInstance = new TransitionInstanceImpl();
        transitionInstance.setId(execution.getId());
        transitionInstance.setParentActivityInstanceId(execution.getParentActivityInstanceId());
        transitionInstance.setProcessInstanceId(execution.getProcessInstanceId());
        transitionInstance.setProcessDefinitionId(execution.getProcessDefinitionId());
        transitionInstance.setExecutionId(execution.getId());
        transitionInstance.setActivityId(execution.getActivityId());
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            String name = activity.getName();
            if (name == null) {
                name = (String)activity.getProperty("name");
            }
            transitionInstance.setActivityName(name);
            transitionInstance.setActivityType((String)activity.getProperty("type"));
        }
        return transitionInstance;
    }

    protected void populateChildInstances(Map<String, ActivityInstanceImpl> activityInstances, Map<String, TransitionInstanceImpl> transitionInstances) {
        List childInstances;
        ActivityInstanceImpl instance;
        ActivityInstanceImpl parentInstance;
        HashMap childActivityInstances = new HashMap();
        HashMap childTransitionInstances = new HashMap();
        for (ActivityInstanceImpl activityInstanceImpl : activityInstances.values()) {
            if (activityInstanceImpl.getParentActivityInstanceId() == null) continue;
            parentInstance = activityInstances.get(activityInstanceImpl.getParentActivityInstanceId());
            if (parentInstance == null) {
                throw new ProcessEngineException("No parent activity instance with id " + activityInstanceImpl.getParentActivityInstanceId() + " generated");
            }
            this.putListElement(childActivityInstances, parentInstance, activityInstanceImpl);
        }
        for (TransitionInstanceImpl transitionInstanceImpl : transitionInstances.values()) {
            if (transitionInstanceImpl.getParentActivityInstanceId() == null) continue;
            parentInstance = activityInstances.get(transitionInstanceImpl.getParentActivityInstanceId());
            if (parentInstance == null) {
                throw new ProcessEngineException("No parent activity instance with id " + transitionInstanceImpl.getParentActivityInstanceId() + " generated");
            }
            this.putListElement(childTransitionInstances, parentInstance, transitionInstanceImpl);
        }
        for (Map.Entry entry : childActivityInstances.entrySet()) {
            instance = (ActivityInstanceImpl)entry.getKey();
            childInstances = (List)entry.getValue();
            if (childInstances == null) continue;
            instance.setChildActivityInstances(childInstances.toArray(new ActivityInstanceImpl[childInstances.size()]));
        }
        for (Map.Entry entry : childTransitionInstances.entrySet()) {
            instance = (ActivityInstanceImpl)entry.getKey();
            childInstances = (List)entry.getValue();
            if (childTransitionInstances == null) continue;
            instance.setChildTransitionInstances(childInstances.toArray(new TransitionInstanceImpl[childInstances.size()]));
        }
    }

    protected <S, T> void putListElement(Map<S, List<T>> mapOfLists, S key, T listElement) {
        List<T> list = mapOfLists.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            mapOfLists.put(key, list);
        }
        list.add(listElement);
    }

    protected ExecutionEntity filterProcessInstance(List<ExecutionEntity> executionList) {
        for (ExecutionEntity execution : executionList) {
            if (!execution.isProcessInstanceExecution()) continue;
            return execution;
        }
        throw new ProcessEngineException("Could not determine process instance execution");
    }

    protected List<ExecutionEntity> filterLeaves(List<ExecutionEntity> executionList) {
        ArrayList<ExecutionEntity> leaves = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity execution : executionList) {
            if (!execution.getNonEventScopeExecutions().isEmpty() && !execution.isCompensationThrowing()) continue;
            leaves.add(execution);
        }
        return leaves;
    }

    protected List<ExecutionEntity> filterNonEventScopeExecutions(List<ExecutionEntity> executionList) {
        ArrayList<ExecutionEntity> nonEventScopeExecutions = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity execution : executionList) {
            if (execution.isEventScope()) continue;
            nonEventScopeExecutions.add(execution);
        }
        return nonEventScopeExecutions;
    }

    protected List<ExecutionEntity> loadProcessInstance(String processInstanceId, CommandContext commandContext) {
        List<ExecutionEntity> result = null;
        List<ExecutionEntity> cachedExecutions = commandContext.getDbEntityManager().getCachedEntitiesByType(ExecutionEntity.class);
        for (ExecutionEntity executionEntity : cachedExecutions) {
            if (!processInstanceId.equals(executionEntity.getProcessInstanceId())) continue;
            result = new ArrayList<ExecutionEntity>();
            ExecutionEntity processInstance = executionEntity.getProcessInstance();
            result.add(processInstance);
            this.loadChildExecutionsFromCache(processInstance, result);
            break;
        }
        if (result == null) {
            result = this.loadFromDb(processInstanceId, commandContext);
        }
        return result;
    }

    protected List<ExecutionEntity> loadFromDb(final String processInstanceId, final CommandContext commandContext) {
        List<ExecutionEntity> executions = commandContext.runWithoutAuthorization(new Callable<List<ExecutionEntity>>(){

            @Override
            public List<ExecutionEntity> call() throws Exception {
                return new ExecutionQueryImpl(commandContext).processInstanceId(processInstanceId).list();
            }
        });
        HashMap executionsByParent = new HashMap();
        for (ExecutionEntity execution : executions) {
            this.putListElement(executionsByParent, execution.getParentId(), execution);
        }
        for (ExecutionEntity execution : executions) {
            List children = (List)executionsByParent.get(execution.getId());
            if (children != null) {
                execution.setExecutions(children);
                for (ExecutionEntity child : children) {
                    child.setParent(execution);
                }
                continue;
            }
            execution.setExecutions(new ArrayList<ExecutionEntity>());
        }
        return executions;
    }

    protected void loadChildExecutionsFromCache(ExecutionEntity execution, List<ExecutionEntity> childExecutions) {
        List<ExecutionEntity> childrenOfThisExecution = execution.getExecutions();
        if (childrenOfThisExecution != null) {
            childExecutions.addAll(childrenOfThisExecution);
            for (ExecutionEntity child : childrenOfThisExecution) {
                this.loadChildExecutionsFromCache(child, childExecutions);
            }
        }
    }
}

