/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.types;

import java.util.UUID;
import org.beanio.types.TypeConversionException;
import org.beanio.types.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUIDTypeHandler
implements TypeHandler {
    @Override
    public Object parse(String text) throws TypeConversionException {
        if (text == null || "".equals(text)) {
            return null;
        }
        try {
            return UUID.fromString(text);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeConversionException("Invalid UUID value '" + text + "'", ex);
        }
    }

    @Override
    public String format(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Class<?> getType() {
        return UUID.class;
    }
}

