/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.xml;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.beanio.internal.util.Settings;
import org.beanio.internal.util.StatefulWriter;
import org.beanio.stream.RecordWriter;
import org.beanio.stream.xml.ElementStack;
import org.beanio.stream.xml.XmlParserConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlWriter
implements RecordWriter,
StatefulWriter {
    public static final String IS_NAMESPACE_IGNORED = "isNamespaceIgnored";
    public static final String IS_DEFAULT_NAMESPACE = "isDefaultNamespace";
    public static final String IS_GROUP_ELEMENT = "isGroup";
    private static final boolean DELTA_ENABLED = "true".equals(Settings.getInstance().getProperty("org.beanio.stream.xml.XmlWriter.deltaEnabled"));
    private static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private static final String OUTPUT_HEADER_KEY = "header";
    private static final String NAMESPACE_MAP_KEY = "nsMap";
    private static final String LEVEL_KEY = "level";
    private static final String STACK_ELEMENT_KEY = "xml";
    private static final String STACK_NS_MAP_KEY = "nsMap";
    private Writer writer;
    private XMLStreamWriter out;
    private XmlParserConfiguration config;
    private String indentation = "";
    private int level = 0;
    private ElementStack elementStack;
    private boolean outputHeader = false;
    private int namespaceCount = 0;
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private int dirtyLevel = 0;
    private boolean suppressOutput = false;

    public XmlWriter(Writer writer) {
        this(writer, null);
    }

    public XmlWriter(Writer writer, XmlParserConfiguration config) {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null");
        }
        this.writer = new FilterWriter(writer){

            public void write(int c) throws IOException {
                if (!XmlWriter.this.suppressOutput) {
                    super.write(c);
                }
            }

            public void write(char[] cbuf, int off, int len) throws IOException {
                if (!XmlWriter.this.suppressOutput) {
                    super.write(cbuf, off, len);
                }
            }

            public void write(String str, int off, int len) throws IOException {
                if (!XmlWriter.this.suppressOutput) {
                    super.write(str, off, len);
                }
            }
        };
        this.config = config == null ? new XmlParserConfiguration() : config.clone();
        this.init();
        try {
            this.out = xmlOutputFactory.createXMLStreamWriter(this.writer);
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException("Failed to create XMLStreamWriter: " + e.getMessage(), e);
        }
    }

    private void init() {
        if (this.config.getLineSeparator() == null) {
            this.config.setLineSeparator(DEFAULT_LINE_SEPARATOR);
        }
        if (this.config.isIndentationEnabled()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.config.getIndentation(); ++i) {
                b.append(' ');
            }
            this.indentation = b.toString();
        }
        this.outputHeader = !this.config.isSuppressHeader();
    }

    @Override
    public void write(Object record) throws IOException {
        try {
            if (this.outputHeader) {
                String encoding = this.config.getEncoding();
                if (encoding != null && encoding.length() != 0) {
                    this.out.writeStartDocument(encoding, this.config.getVersion());
                } else {
                    this.out.writeStartDocument(this.config.getVersion());
                }
                if (this.config.isIndentationEnabled()) {
                    this.out.writeCharacters(this.config.getLineSeparator());
                }
                this.outputHeader = false;
            }
            if (record == null) {
                if (this.elementStack != null) {
                    this.endElement();
                }
            } else {
                this.write(((Document)record).getDocumentElement(), this.config.isIndentationEnabled());
            }
        }
        catch (XMLStreamException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private void write(Element element, boolean indentationEnabled) throws XMLStreamException {
        String name = element.getLocalName();
        String prefix = element.getPrefix();
        String namespace = element.getNamespaceURI();
        boolean ignoreNamespace = false;
        if (namespace == null) {
            if (Boolean.TRUE.equals(element.getUserData(IS_NAMESPACE_IGNORED))) {
                prefix = null;
                ignoreNamespace = true;
            }
            namespace = "";
        }
        boolean setDefaultNamespace = false;
        if (prefix == null && !ignoreNamespace && Boolean.TRUE.equals(element.getUserData(IS_DEFAULT_NAMESPACE))) {
            setDefaultNamespace = true;
        }
        boolean empty = false;
        boolean pendingStackUpdate = true;
        if (this.elementStack == null) {
            if (ignoreNamespace) {
                this.out.writeStartElement(name);
            } else if (prefix != null) {
                this.out.writeStartElement(prefix, name, namespace);
                this.out.writeNamespace(prefix, namespace);
            } else {
                this.out.writeStartElement(name);
                this.out.writeDefaultNamespace(namespace);
            }
            this.push(namespace, prefix, name);
            for (Map.Entry<String, String> ns : this.config.getNamespaceMap().entrySet()) {
                this.out.writeNamespace(ns.getKey(), ns.getValue());
                this.elementStack.addNamespace(ns.getKey(), ns.getValue());
            }
            pendingStackUpdate = false;
        } else {
            if (indentationEnabled) {
                this.newLine();
            }
            boolean bl = empty = !element.hasChildNodes();
            if (ignoreNamespace || this.elementStack.isDefaultNamespace(namespace) && prefix == null) {
                if (empty) {
                    this.out.writeEmptyElement(name);
                } else {
                    this.out.writeStartElement(name);
                }
                namespace = this.elementStack.getDefaultNamespace();
                prefix = null;
            } else {
                String p = this.elementStack.findPrefix(namespace);
                boolean declareNamespace = false;
                if (p == null) {
                    declareNamespace = true;
                } else if (prefix == null && !setDefaultNamespace) {
                    prefix = p;
                }
                if (prefix == null) {
                    if (empty) {
                        this.out.writeEmptyElement(name);
                    } else {
                        this.out.writeStartElement(name);
                    }
                } else if (empty) {
                    this.out.writeEmptyElement(prefix, name, namespace);
                } else {
                    this.out.writeStartElement(prefix, name, namespace);
                }
                if (setDefaultNamespace) {
                    this.out.writeDefaultNamespace(namespace);
                } else if (declareNamespace) {
                    this.out.writeNamespace(prefix, namespace);
                }
            }
        }
        HashSet<String> attPrefixSet = null;
        NamedNodeMap map = element.getAttributes();
        if (map.getLength() > 0 && pendingStackUpdate) {
            this.push(namespace, prefix, name);
            pendingStackUpdate = false;
        }
        int j = map.getLength();
        for (int i = 0; i < j; ++i) {
            Attr att = (Attr)map.item(i);
            String attName = att.getLocalName();
            String attNamespace = att.getNamespaceURI();
            String attPrefix = att.getPrefix();
            if (attNamespace == null) {
                this.out.writeAttribute(attName, att.getValue());
                continue;
            }
            String p = this.elementStack.findPrefix(attNamespace);
            boolean declareNamespace = false;
            if (p == null) {
                if (attPrefix == null && (attPrefix = this.namespaceMap.get(attNamespace)) == null) {
                    attPrefix = this.createNamespace(attNamespace);
                }
                if (attPrefixSet == null || !attPrefixSet.contains(attPrefix)) {
                    declareNamespace = true;
                }
            } else if (attPrefix == null) {
                attPrefix = p;
            }
            if (declareNamespace) {
                this.out.writeNamespace(attPrefix, attNamespace);
                if (attPrefixSet == null) {
                    attPrefixSet = new HashSet<String>();
                }
                attPrefixSet.add(attPrefix);
            }
            this.out.writeAttribute(attPrefix, attNamespace, attName, att.getValue());
        }
        if (indentationEnabled) {
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 3) continue;
                indentationEnabled = false;
                break;
            }
        }
        boolean isParent = false;
        block7: for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    if (pendingStackUpdate) {
                        this.push(namespace, prefix, name);
                        pendingStackUpdate = false;
                    }
                    this.write((Element)child, indentationEnabled);
                    isParent = true;
                    continue block7;
                }
                case 3: {
                    this.out.writeCharacters(((Text)child).getData());
                    continue block7;
                }
            }
        }
        if (!Boolean.TRUE.equals(element.getUserData(IS_GROUP_ELEMENT))) {
            if (!pendingStackUpdate) {
                this.pop();
            }
            if (!empty) {
                if (isParent && indentationEnabled) {
                    this.newLine();
                }
                this.out.writeEndElement();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (XMLStreamException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            while (this.elementStack != null) {
                this.endElement();
            }
            this.out.writeEndDocument();
            this.out.flush();
            this.out.close();
            this.writer.flush();
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private String createNamespace(String uri) {
        String prefix = "http://www.w3.org/2001/XMLSchema-instance".equals(uri) ? Settings.getInstance().getProperty("org.beanio.xml.xsiNamespacePrefix") : "ns" + ++this.namespaceCount;
        while (this.namespaceMap.containsValue(prefix)) {
            prefix = "ns" + ++this.namespaceCount;
        }
        this.namespaceMap.put(uri, prefix);
        return prefix;
    }

    private void newLine() throws XMLStreamException {
        if (this.config.isIndentationEnabled()) {
            this.out.writeCharacters(this.config.getLineSeparator());
            int j = this.level;
            for (int i = 0; i < j; ++i) {
                this.out.writeCharacters(this.indentation);
            }
        }
    }

    private void endElement() throws XMLStreamException {
        this.pop();
        this.newLine();
        this.out.writeEndElement();
    }

    private void push(String namespace, String prefix, String name) {
        this.push(new ElementStack(this.elementStack, namespace, prefix, name));
    }

    private void push(ElementStack e) {
        this.elementStack = e;
        ++this.level;
    }

    private ElementStack pop() {
        ElementStack e = this.elementStack;
        this.elementStack = this.elementStack.getParent();
        --this.level;
        this.dirtyLevel = Math.min(this.dirtyLevel, this.level);
        return e;
    }

    @Override
    public void updateState(String namespace, Map<String, Object> state) {
        int lastLevel;
        state.put(this.getKey(namespace, OUTPUT_HEADER_KEY), this.outputHeader);
        state.put(this.getKey(namespace, "nsMap"), this.toToken(this.namespaceMap));
        Integer n = (Integer)state.get(this.getKey(namespace, LEVEL_KEY));
        for (int i = lastLevel = n == null ? 0 : n; i > this.level; --i) {
            String stackPrefix = namespace + ".s" + i;
            state.remove(this.getKey(stackPrefix, STACK_ELEMENT_KEY));
            state.remove(this.getKey(stackPrefix, "nsMap"));
        }
        int to = DELTA_ENABLED ? this.dirtyLevel : 0;
        ElementStack e = this.elementStack;
        for (int i = this.level; i > to; --i) {
            String stackPrefix = namespace + ".s" + i;
            state.put(this.getKey(stackPrefix, STACK_ELEMENT_KEY), e.toToken());
            String nsMapKey = this.getKey(stackPrefix, "nsMap");
            String token = this.toToken(e.getNamespaces());
            if (token == null) {
                state.remove(nsMapKey);
            } else {
                state.put(nsMapKey, token);
            }
            e = this.elementStack.getParent();
        }
        this.dirtyLevel = this.level;
        state.put(this.getKey(namespace, LEVEL_KEY), this.level);
    }

    @Override
    public void restoreState(String namespace, Map<String, Object> state) throws IllegalStateException {
        this.outputHeader = (Boolean)this.getRequired(namespace, OUTPUT_HEADER_KEY, state);
        String key = this.getKey(namespace, "nsMap");
        String token = (String)state.get(key);
        if (token != null) {
            this.namespaceMap = this.toMap(token, key);
            this.namespaceCount = this.namespaceMap.size();
        } else {
            this.namespaceCount = 0;
        }
        this.level = 0;
        this.elementStack = null;
        try {
            this.out.flush();
            this.suppressOutput = true;
            int level = (Integer)this.getRequired(namespace, LEVEL_KEY, state);
            for (int i = 0; i < level; ++i) {
                String stackPrefix = namespace + ".s" + (i + 1);
                ElementStack e = ElementStack.fromToken(this.elementStack, (String)this.getRequired(stackPrefix, STACK_ELEMENT_KEY, state));
                if (e.isDefaultNamespace()) {
                    this.out.writeStartElement(e.getName());
                } else if (e.getPrefix() == null) {
                    this.out.writeStartElement(e.getName());
                    this.out.writeDefaultNamespace(e.getNamespace());
                } else {
                    this.out.writeStartElement(e.getPrefix(), e.getName(), e.getNamespace());
                }
                this.push(e);
                String nsMap = (String)state.get(this.getKey(stackPrefix, "nsMap"));
                if (nsMap == null) continue;
                String[] s = nsMap.trim().split(" ");
                if (s.length % 2 != 0) {
                    throw new IllegalStateException("Invalid state information for key '" + this.getKey(stackPrefix, "nsMap") + "'");
                }
                for (int n = 0; n < s.length; n += 2) {
                    this.elementStack.addNamespace(s[n + 1], s[n]);
                    this.out.writeNamespace(s[n + 1], s[n]);
                }
            }
            this.out.writeCharacters(" ");
            this.out.flush();
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.suppressOutput = false;
        }
        this.dirtyLevel = this.level;
    }

    private Object getRequired(String namespace, String key, Map<String, Object> state) {
        Object value = state.get(key = this.getKey(namespace, key));
        if (value == null) {
            throw new IllegalStateException("Missing state information for key '" + key + "'");
        }
        return value;
    }

    private String getKey(String namespace, String name) {
        return namespace + "." + name;
    }

    private Map<String, String> toMap(String token, String key) {
        if (token == null) {
            return null;
        }
        String[] s = token.trim().split(" ");
        if (s.length % 2 != 0) {
            throw new IllegalStateException("Invalid state information for key '" + key + "'");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int n = 0; n < s.length; n += 2) {
            map.put(s[n], s[n + 1]);
        }
        return map;
    }

    private String toToken(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        boolean first = true;
        StringBuilder token = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                token.append(" ");
            }
            token.append(entry.getKey());
            token.append(" ");
            token.append(entry.getValue());
        }
        return token.toString();
    }
}

