/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.xml;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.beanio.BeanIOException;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordUnmarshaller;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlRecordUnmarshaller
implements RecordUnmarshaller {
    private static final DocumentBuilder documentBuilder;

    public Object unmarshal(String text) throws RecordIOException {
        try {
            return documentBuilder.parse(new InputSource(new StringReader(text)));
        }
        catch (IOException ex) {
            throw new RecordIOException(ex);
        }
        catch (SAXException e) {
            throw new RecordIOException(e.getMessage(), e);
        }
    }

    static {
        try {
            DocumentBuilderFactory domBuilderFactory = DocumentBuilderFactory.newInstance();
            domBuilderFactory.setIgnoringComments(true);
            domBuilderFactory.setCoalescing(true);
            domBuilderFactory.setNamespaceAware(true);
            domBuilderFactory.setValidating(false);
            documentBuilder = domBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new BeanIOException(ex);
        }
    }
}

