/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.xml;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.beanio.internal.util.Settings;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordMarshaller;
import org.beanio.stream.xml.ElementStack;
import org.beanio.stream.xml.XmlParserConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlRecordMarshaller
implements RecordMarshaller {
    private static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private XmlParserConfiguration config;
    private String indentation = "";
    private int level = 0;
    private ElementStack elementStack;
    private boolean outputHeader = false;
    private int namespaceCount = 0;
    private Map<String, String> namespaceMap = new HashMap<String, String>();

    public XmlRecordMarshaller() {
        this(null);
    }

    public XmlRecordMarshaller(XmlParserConfiguration config) {
        this.config = config == null ? new XmlParserConfiguration() : config.clone();
        this.init();
    }

    private void init() {
        if (this.config.getLineSeparator() == null) {
            this.config.setLineSeparator(DEFAULT_LINE_SEPARATOR);
        }
        if (this.config.isIndentationEnabled()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.config.getIndentation(); ++i) {
                b.append(' ');
            }
            this.indentation = b.toString();
        }
        this.outputHeader = !this.config.isSuppressHeader();
    }

    public String marshal(Object record) throws RecordIOException {
        try {
            return this.marshal((Document)record);
        }
        catch (XMLStreamException ex) {
            throw new RecordIOException("Failed to marshal XML record: " + ex.getMessage(), ex);
        }
    }

    protected String marshal(Document document) throws XMLStreamException {
        XMLStreamWriter out;
        StringWriter output = new StringWriter();
        try {
            out = xmlOutputFactory.createXMLStreamWriter(output);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Failed to create XMLStreamWriter: " + e.getMessage(), e);
        }
        if (this.outputHeader) {
            String encoding = this.config.getEncoding();
            if (encoding != null && encoding.length() != 0) {
                out.writeStartDocument(encoding, this.config.getVersion());
            } else {
                out.writeStartDocument(this.config.getVersion());
            }
            if (this.config.isIndentationEnabled()) {
                out.writeCharacters(this.config.getLineSeparator());
            }
        }
        this.write(out, document.getDocumentElement(), this.config.isIndentationEnabled());
        return output.toString();
    }

    private void write(XMLStreamWriter out, Element element, boolean indentationEnabled) throws XMLStreamException {
        String name = element.getLocalName();
        String prefix = element.getPrefix();
        String namespace = element.getNamespaceURI();
        boolean ignoreNamespace = false;
        if (namespace == null) {
            if (Boolean.TRUE.equals(element.getUserData("isNamespaceIgnored"))) {
                prefix = null;
                ignoreNamespace = true;
            }
            namespace = "";
        }
        boolean setDefaultNamespace = false;
        if (prefix == null && !ignoreNamespace && Boolean.TRUE.equals(element.getUserData("isDefaultNamespace"))) {
            setDefaultNamespace = true;
        }
        boolean empty = false;
        boolean pendingStackUpdate = true;
        if (this.elementStack == null) {
            if (ignoreNamespace) {
                out.writeStartElement(name);
            } else if (prefix != null) {
                out.writeStartElement(prefix, name, namespace);
                out.writeNamespace(prefix, namespace);
            } else {
                out.writeStartElement(name);
                out.writeDefaultNamespace(namespace);
            }
            this.push(namespace, prefix, name);
            for (Map.Entry<String, String> ns : this.config.getNamespaceMap().entrySet()) {
                out.writeNamespace(ns.getKey(), ns.getValue());
                this.elementStack.addNamespace(ns.getKey(), ns.getValue());
            }
            pendingStackUpdate = false;
        } else {
            if (indentationEnabled) {
                this.newLine(out);
            }
            boolean bl = empty = !element.hasChildNodes();
            if (ignoreNamespace || this.elementStack.isDefaultNamespace(namespace) && prefix == null) {
                if (empty) {
                    out.writeEmptyElement(name);
                } else {
                    out.writeStartElement(name);
                }
                namespace = this.elementStack.getDefaultNamespace();
                prefix = null;
            } else {
                String p = this.elementStack.findPrefix(namespace);
                boolean declareNamespace = false;
                if (p == null) {
                    declareNamespace = true;
                } else if (prefix == null && !setDefaultNamespace) {
                    prefix = p;
                }
                if (prefix == null) {
                    if (empty) {
                        out.writeEmptyElement(name);
                    } else {
                        out.writeStartElement(name);
                    }
                } else if (empty) {
                    out.writeEmptyElement(prefix, name, namespace);
                } else {
                    out.writeStartElement(prefix, name, namespace);
                }
                if (setDefaultNamespace) {
                    out.writeDefaultNamespace(namespace);
                } else if (declareNamespace) {
                    out.writeNamespace(prefix, namespace);
                }
            }
        }
        HashSet<String> attPrefixSet = null;
        NamedNodeMap map = element.getAttributes();
        if (map.getLength() > 0 && pendingStackUpdate) {
            this.push(namespace, prefix, name);
            pendingStackUpdate = false;
        }
        int j = map.getLength();
        for (int i = 0; i < j; ++i) {
            Attr att = (Attr)map.item(i);
            String attName = att.getLocalName();
            String attNamespace = att.getNamespaceURI();
            String attPrefix = att.getPrefix();
            if (attNamespace == null) {
                out.writeAttribute(attName, att.getValue());
                continue;
            }
            String p = this.elementStack.findPrefix(attNamespace);
            boolean declareNamespace = false;
            if (p == null) {
                if (attPrefix == null && (attPrefix = this.namespaceMap.get(attNamespace)) == null) {
                    attPrefix = this.createNamespace(attNamespace);
                }
                if (attPrefixSet == null || !attPrefixSet.contains(attPrefix)) {
                    declareNamespace = true;
                }
            } else if (attPrefix == null) {
                attPrefix = p;
            }
            if (declareNamespace) {
                out.writeNamespace(attPrefix, attNamespace);
                if (attPrefixSet == null) {
                    attPrefixSet = new HashSet<String>();
                }
                attPrefixSet.add(attPrefix);
            }
            out.writeAttribute(attPrefix, attNamespace, attName, att.getValue());
        }
        if (indentationEnabled) {
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 3) continue;
                indentationEnabled = false;
                break;
            }
        }
        boolean isParent = false;
        block7: for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    if (pendingStackUpdate) {
                        this.push(namespace, prefix, name);
                        pendingStackUpdate = false;
                    }
                    this.write(out, (Element)child, indentationEnabled);
                    isParent = true;
                    continue block7;
                }
                case 3: {
                    out.writeCharacters(((Text)child).getData());
                    continue block7;
                }
            }
        }
        if (!pendingStackUpdate) {
            this.pop();
        }
        if (!empty) {
            if (isParent && indentationEnabled) {
                this.newLine(out);
            }
            out.writeEndElement();
        }
    }

    private String createNamespace(String uri) {
        String prefix = "http://www.w3.org/2001/XMLSchema-instance".equals(uri) ? Settings.getInstance().getProperty("org.beanio.xml.xsiNamespacePrefix") : "ns" + ++this.namespaceCount;
        while (this.namespaceMap.containsValue(prefix)) {
            prefix = "ns" + ++this.namespaceCount;
        }
        this.namespaceMap.put(uri, prefix);
        return prefix;
    }

    private void newLine(XMLStreamWriter out) throws XMLStreamException {
        if (this.config.isIndentationEnabled()) {
            out.writeCharacters(this.config.getLineSeparator());
            int j = this.level;
            for (int i = 0; i < j; ++i) {
                out.writeCharacters(this.indentation);
            }
        }
    }

    private void push(String namespace, String prefix, String name) {
        this.push(new ElementStack(this.elementStack, namespace, prefix, name));
    }

    private void push(ElementStack e) {
        this.elementStack = e;
        ++this.level;
    }

    private ElementStack pop() {
        --this.level;
        ElementStack e = this.elementStack;
        this.elementStack = this.elementStack.getParent();
        return e;
    }
}

