/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.util;

import java.io.IOException;
import java.io.Reader;

public class CommentReader {
    private Reader in;
    private String[] comments;
    private char[] commentBuffer;
    private char recordTerminator = '\u0000';
    private boolean skipLF;
    private boolean eof;

    public CommentReader(Reader in, String[] comments) throws IllegalArgumentException {
        this(in, comments, null);
    }

    public CommentReader(Reader in, String[] comments, Character recordTerminator) throws IllegalArgumentException {
        if (comments == null) {
            throw new IllegalArgumentException("Comments not set");
        }
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Comments require reader.markSupported() to return true");
        }
        this.in = in;
        this.comments = comments;
        if (recordTerminator != null) {
            this.recordTerminator = recordTerminator.charValue();
        }
        int maximumCommentLength = 0;
        for (String s : comments) {
            if (s == null || s.length() == 0) {
                throw new IllegalArgumentException("Comment value cannot be null or empty string");
            }
            maximumCommentLength = Math.max(maximumCommentLength, s.length());
        }
        this.commentBuffer = new char[maximumCommentLength + 1];
    }

    public boolean isSkipLF() {
        return this.skipLF;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public int skipComments(boolean initialSkipLF) throws IOException {
        int lines;
        block5: {
            int n;
            this.skipLF = initialSkipLF;
            lines = 0;
            block0: do {
                this.in.mark(this.commentBuffer.length);
                n = this.in.read(this.commentBuffer);
                if (n <= 0) break block5;
                String linePrefix = this.skipLF && this.commentBuffer[0] == '\n' ? new String(this.commentBuffer, 1, n - 1) : new String(this.commentBuffer, 0, n);
                boolean commentFound = false;
                for (String s : this.comments) {
                    if (!linePrefix.startsWith(s)) continue;
                    commentFound = true;
                    ++lines;
                    break;
                }
                if (!commentFound) break block5;
                this.in.reset();
                while ((n = this.in.read()) != -1) {
                    char c = (char)n;
                    if (this.recordTerminator == '\u0000') {
                        if (this.skipLF) {
                            this.skipLF = false;
                            if (c == '\n') continue;
                        }
                        if (c == '\n') continue block0;
                        if (c != '\r') continue;
                        this.skipLF = true;
                        continue block0;
                    }
                    if (c != this.recordTerminator) continue;
                    continue block0;
                }
            } while (n != -1);
            this.eof = true;
            return lines;
        }
        this.in.reset();
        return lines;
    }
}

