/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.json;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordUnmarshaller;
import org.beanio.stream.json.JsonReaderSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRecordUnmarshaller
extends JsonReaderSupport
implements RecordUnmarshaller {
    private StringReader reader = new StringReader();

    public JsonRecordUnmarshaller() {
        this.setReader(this.reader);
    }

    @Override
    public Map<String, Object> unmarshal(String text) throws RecordIOException {
        if (text == null) {
            return null;
        }
        Map<String, Object> map = null;
        this.reader.setText(text);
        try {
            int n;
            int state = 0;
            while ((n = this.in.read()) != -1) {
                char c = (char)n;
                switch (state) {
                    case 0: {
                        if (c == '{') {
                            map = super.readObject();
                            state = 1;
                            break;
                        }
                        if (this.isWhitespace(c)) break;
                        throw new RecordIOException("Unexpected character");
                    }
                    case 1: {
                        if (this.isWhitespace((char)n)) break;
                        throw new RecordIOException("Unexpected character");
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected IOException caught", ex);
        }
        catch (RecordIOException ex) {
            throw new RecordIOException(ex.getMessage() + " near position " + this.reader.getPosition(), ex);
        }
        if (map == null) {
            throw new RecordIOException("Expected '{' near position 1");
        }
        return map;
    }

    private static class StringReader
    extends Reader {
        private char[] buffer;
        private int position;

        private StringReader() {
        }

        public void setText(String text) {
            this.buffer = text.toCharArray();
            this.position = 0;
        }

        public int getPosition() {
            return this.position;
        }

        public int read() {
            if (this.position < this.buffer.length) {
                return this.buffer[this.position++];
            }
            return -1;
        }

        public int read(char[] cbuf, int off, int len) {
            if (this.position < this.buffer.length) {
                len = Math.min(len, this.buffer.length - this.position);
                System.arraycopy(this.buffer, this.position, cbuf, off, len);
                this.position += len;
                return len;
            }
            return -1;
        }

        public void close() {
        }
    }
}

