/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.json;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beanio.internal.util.JsonUtil;
import org.beanio.stream.RecordIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonReaderSupport {
    protected Reader in;
    protected boolean eof;

    JsonReaderSupport() {
    }

    protected void setReader(Reader in) {
        this.in = in;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Map<String, Object> readObject() throws IOException {
        int n;
        String fieldName = null;
        StringBuilder text = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        int state = 0;
        block15: while ((n = this.in.read()) != -1) {
            char c = (char)n;
            switch (state) {
                case -1: {
                    if (c == '}') {
                        return map;
                    }
                    if (c == ',') {
                        state = 1;
                        break;
                    }
                    if (this.isWhitespace(c)) break;
                    break block15;
                }
                case 0: {
                    if (c == '}') {
                        return map;
                    }
                }
                case 1: {
                    if (c == '\"') {
                        fieldName = this.readString();
                        state = 2;
                        break;
                    }
                    if (this.isWhitespace(c)) break;
                    break block15;
                }
                case 2: {
                    if (c == ':') {
                        state = 3;
                        break;
                    }
                    if (this.isWhitespace(c)) break;
                    break block15;
                }
                case 3: {
                    if (c == '\"') {
                        map.put(fieldName, this.readString());
                        state = -1;
                        break;
                    }
                    if (c == '{') {
                        map.put(fieldName, this.readObject());
                        state = -1;
                        break;
                    }
                    if (c == '[') {
                        map.put(fieldName, this.readArray());
                        state = -1;
                        break;
                    }
                    if (this.isWhitespace(c)) break;
                    text = new StringBuilder();
                    text.append(c);
                    state = 4;
                    break;
                }
                case 4: {
                    if (c == ',') {
                        map.put(fieldName, this.parseValue(text.toString()));
                        state = 1;
                        break;
                    }
                    if (c == '}') {
                        map.put(fieldName, this.parseValue(text.toString()));
                        return map;
                    }
                    if (this.isWhitespace(c)) {
                        map.put(fieldName, this.parseValue(text.toString()));
                        state = -1;
                        break;
                    }
                    text.append(c);
                }
            }
        }
        if (n < 0) {
            this.eof = true;
        }
        switch (state) {
            case 0: {
                throw new RecordIOException("Expected string or '}'");
            }
            case -1: 
            case 4: {
                throw new RecordIOException("Expected ',' or '}'");
            }
            case 1: {
                throw new RecordIOException("Expected '\"'");
            }
            case 2: {
                throw new RecordIOException("Expected ':'");
            }
            case 3: {
                throw new RecordIOException("Expected value");
            }
        }
        throw new RecordIOException("Unexpected end of record");
    }

    protected List<Object> readArray() throws IOException {
        int n;
        ArrayList<Object> list = new ArrayList<Object>();
        StringBuilder text = null;
        int state = 0;
        while ((n = this.in.read()) != -1) {
            char c = (char)n;
            switch (state) {
                case -1: {
                    if (c == ']') {
                        return list;
                    }
                    if (c == ',') {
                        state = 1;
                        break;
                    }
                    if (this.isWhitespace(c)) break;
                    throw new RecordIOException("Expected ','");
                }
                case 0: {
                    if (c == ']') {
                        return list;
                    }
                }
                case 1: {
                    if (c == '\"') {
                        list.add(this.readString());
                        state = -1;
                        break;
                    }
                    if (c == '{') {
                        list.add(this.readObject());
                        state = -1;
                        break;
                    }
                    if (c == '[') {
                        list.add(this.readArray());
                        state = -1;
                        break;
                    }
                    if (this.isWhitespace(c)) break;
                    text = new StringBuilder();
                    text.append(c);
                    state = 2;
                    break;
                }
                case 2: {
                    if (c == ',') {
                        list.add(this.parseValue(text.toString()));
                        state = 1;
                        break;
                    }
                    if (c == ']') {
                        list.add(this.parseValue(text.toString()));
                        return list;
                    }
                    if (this.isWhitespace(c)) {
                        list.add(this.parseValue(text.toString()));
                        state = -1;
                        break;
                    }
                    text.append(c);
                }
            }
        }
        this.eof = true;
        switch (state) {
            case 0: 
            case 2: {
                throw new RecordIOException("Expected ',' or ']'");
            }
            case 1: {
                throw new RecordIOException("Expected value");
            }
        }
        throw new RecordIOException("Unexpected end of record");
    }

    protected Object parseValue(String text) throws IOException {
        if ("null".equals(text)) {
            return null;
        }
        if ("true".equals(text)) {
            return Boolean.TRUE;
        }
        if ("false".equals(text)) {
            return Boolean.FALSE;
        }
        try {
            return JsonUtil.toNumber(text);
        }
        catch (NumberFormatException ex) {
            throw new RecordIOException("Cannot parse '" + text + "' into a JSON string, number or boolean", ex);
        }
    }

    protected String readString() throws IOException {
        int n;
        StringBuilder text = new StringBuilder();
        int state = 0;
        while ((n = this.in.read()) != -1) {
            char c = (char)n;
            switch (state) {
                case 0: {
                    if (c == '\"') {
                        return text.toString();
                    }
                    if (c == '\\') {
                        state = 1;
                        break;
                    }
                    text.append(c);
                    break;
                }
                case 1: {
                    if (c == '\"') {
                        text.append('\"');
                    } else if (c == '\\') {
                        text.append('\\');
                    } else if (c == '/') {
                        text.append('/');
                    } else if (c == 't') {
                        text.append('\t');
                    } else if (c == 'b') {
                        text.append('\b');
                    } else if (c == 'f') {
                        text.append('\f');
                    } else if (c == 'n') {
                        text.append('\n');
                    } else if (c == 'r') {
                        text.append('\r');
                    } else if (c == 'u') {
                        text.append(this.readUnicode());
                    } else {
                        throw new RecordIOException("Invalid escaped character: '" + c + "'");
                    }
                    state = 0;
                }
            }
        }
        this.eof = true;
        throw new RecordIOException("Expected '\"'");
    }

    protected char readUnicode() throws IOException {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int n = this.in.read();
            if (n == -1) {
                this.eof = true;
                throw new RecordIOException("Expected unicode value");
            }
            char c = (char)n;
            if (this.isWhitespace(c)) {
                throw new RecordIOException("Expected unicode value");
            }
            value.append(c);
        }
        try {
            return (char)Integer.valueOf(value.toString(), 16).intValue();
        }
        catch (NumberFormatException ex) {
            throw new RecordIOException("Invalid unicode character '\\u" + value.toString() + "'", ex);
        }
    }

    protected boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }
}

