/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.fixedlength;

import java.io.IOException;
import java.io.Writer;
import org.beanio.stream.RecordIOException;
import org.beanio.stream.RecordWriter;

public class FixedLengthWriter
implements RecordWriter {
    private Writer out;
    private String recordTerminator;

    public FixedLengthWriter(Writer out) {
        this(out, null);
    }

    public FixedLengthWriter(Writer out, String recordTerminator) {
        this.out = out;
        if (recordTerminator == null) {
            recordTerminator = System.getProperty("line.separator");
        }
        this.recordTerminator = recordTerminator;
    }

    public void write(Object value) throws IOException, RecordIOException {
        this.out.write(value.toString());
        this.out.write(this.recordTerminator);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

